/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows;

import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ScarecrowTracker {
    private static final Map<ResourceKey<Level>, Collection<Integer>> trackedScarecrows = new HashMap<ResourceKey<Level>, Collection<Integer>>();

    public static void track(Scarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.m_20193_()).add(entity.m_142049_());
    }

    public static void stopTracking(Scarecrow entity) {
        ScarecrowTracker.getTrackedScarecrows(entity.m_20193_()).remove(entity.m_142049_());
    }

    public static List<Scarecrow> getScarecrowsInRange(Level world, BlockPos pos) {
        Collection<Integer> scarecrows = ScarecrowTracker.getTrackedScarecrows(world);
        ArrayList<Scarecrow> returnValue = new ArrayList<Scarecrow>();
        Iterator<Integer> it = scarecrows.iterator();
        while (it.hasNext()) {
            int scarecrowId = it.next();
            Entity scarecrow = world.m_6815_(scarecrowId);
            if (scarecrow instanceof Scarecrow) {
                if (!ScarecrowTracker.canScarecrowReach((Scarecrow)scarecrow, pos)) continue;
                returnValue.add((Scarecrow)scarecrow);
                continue;
            }
            it.remove();
        }
        return returnValue;
    }

    private static Collection<Integer> getTrackedScarecrows(Level world) {
        Collection<Integer> scarecrows = trackedScarecrows.get(world.m_46472_());
        if (scarecrows == null) {
            scarecrows = new HashSet<Integer>();
            trackedScarecrows.put((ResourceKey<Level>)world.m_46472_(), scarecrows);
        }
        return scarecrows;
    }

    private static boolean canScarecrowReach(Scarecrow entity, BlockPos pos) {
        AABB scarecrowRange = entity.getArea();
        return scarecrowRange.f_82288_ <= (double)pos.m_123341_() && scarecrowRange.f_82289_ <= (double)pos.m_123342_() && scarecrowRange.f_82290_ <= (double)pos.m_123343_() && scarecrowRange.f_82291_ >= (double)pos.m_123341_() && scarecrowRange.f_82292_ >= (double)pos.m_123342_() && scarecrowRange.f_82293_ >= (double)pos.m_123343_();
    }
}

