/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.ai;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunAwayGoal
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = e -> e.m_6084_() && entity.m_21574_().m_148306_(e);
    private Mob entity;
    private final float speed = 1.5f;
    private Path path;
    private final PathNavigation navigation;
    private long ticksSinceSound = 0L;

    public RunAwayGoal(Mob entity) {
        this.entity = entity;
        this.navigation = entity.m_21573_();
    }

    public boolean m_8036_() {
        List<Scarecrow> list = ScarecrowTracker.getScarecrowsInRange(this.entity.f_19853_, this.entity.m_142538_());
        if (list.isEmpty()) {
            return false;
        }
        for (Scarecrow scarecrow : list) {
            if (!this.canBeSeenSelector.apply((Object)scarecrow)) continue;
            if (EntityUtil.isAttackableMonster((Entity)this.entity)) {
                if (!this.shouldScare(scarecrow)) continue;
                return true;
            }
            if (!scarecrow.getScarecrowType().shouldScareAnimals() || !EntityUtil.isAttackableAnimal((Entity)this.entity) || !this.shouldScare(scarecrow)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldScare(Scarecrow scarecrow) {
        List entities = scarecrow.f_19853_.m_45976_(this.entity.getClass(), scarecrow.getArea());
        for (Mob e : entities) {
            if (e != this.entity) continue;
            if (e.m_20270_((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) {
                Vec3 scarecrowPos = new Vec3(scarecrow.m_20185_(), scarecrow.m_20186_(), scarecrow.m_20189_());
                Vec3 currentPos = new Vec3(e.m_20185_(), e.m_20186_(), e.m_20189_());
                Vec3 newPosition = EntityUtil.generateRandomPos(e, 16, 7, currentPos.m_82546_(scarecrowPos), true);
                if (newPosition == null || scarecrow.m_20275_(newPosition.f_82479_, newPosition.f_82480_, newPosition.f_82481_) < scarecrow.m_20280_((Entity)e)) {
                    return false;
                }
                this.path = this.navigation.m_7864_(new BlockPos(newPosition), 0);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.navigation.m_26571_();
    }

    public void m_8056_() {
        this.navigation.m_26536_(this.path, 1.5);
    }

    public void m_8037_() {
        if (this.ticksSinceSound == 0L) {
            this.entity.m_8032_();
            this.createRunningParticles((Entity)this.entity);
            this.ticksSinceSound = 10L;
        } else {
            --this.ticksSinceSound;
        }
        this.entity.m_21573_().m_26517_(1.5);
    }

    private void createRunningParticles(Entity entity) {
        int z;
        int y;
        int x = Mth.m_14107_((double)entity.m_20185_());
        BlockPos pos = new BlockPos(x, y = Mth.m_14107_((double)(entity.m_20186_() - (double)0.2f)), z = Mth.m_14107_((double)entity.m_20189_()));
        BlockState state = entity.f_19853_.m_8055_(pos);
        if (!state.addRunningEffects(entity.f_19853_, pos, entity) && state.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 motion = entity.m_20184_();
            EntityDimensions size = entity.m_6972_(entity.m_20089_());
            Random rand = entity.f_19853_.f_46441_;
            entity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), entity.m_20185_() + (rand.nextDouble() - 0.5) * (double)size.f_20377_, entity.m_20186_() + 0.1, entity.m_20189_() + (rand.nextDouble() - 0.5) * (double)size.f_20377_, motion.f_82479_ * -4.0, 1.5, motion.f_82481_ * -4.0);
        }
    }
}

