/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.entity;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import bl4ckscor3.mod.scarecrows.util.CustomDataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class Scarecrow
extends Entity {
    private static final EntityDataAccessor<ScarecrowType> TYPE = SynchedEntityData.m_135353_(Scarecrow.class, CustomDataSerializers.SCARECROWTYPE);
    private static final EntityDataAccessor<Boolean> LIT = SynchedEntityData.m_135353_(Scarecrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(Scarecrow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<AABB> AREA = SynchedEntityData.m_135353_(Scarecrow.class, CustomDataSerializers.AXISALIGNEDBB);

    public Scarecrow(EntityType<Scarecrow> type, Level world) {
        super(type, world);
    }

    public Scarecrow(Level world) {
        super(Scarecrows.SCARECROW_ENTITY_TYPE, world);
    }

    public Scarecrow(ScarecrowType type, Level world, BlockPos pos, boolean isLit, Direction facing) {
        this(world);
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        this.f_19804_.m_135381_(TYPE, (Object)type);
        this.f_19804_.m_135381_(LIT, (Object)isLit);
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(facing.m_122435_() + 180.0f));
        this.f_19804_.m_135381_(AREA, (Object)new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82377_((double)type.getRange(), (double)(type.getHeight() * 3), (double)type.getRange()));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, null);
        this.f_19804_.m_135372_(LIT, (Object)false);
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(AREA, (Object)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        ScarecrowTracker.track(this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        ScarecrowTracker.stopTracking(this);
    }

    public void m_8119_() {
        if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60795_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.f_19853_.f_46443_) {
            if (this.isLit()) {
                this.f_19853_.m_46961_(this.m_142538_().m_6630_(this.getScarecrowType().getHeight() - 1), false);
            }
            this.getScarecrowType().dropMaterials(this.f_19853_, this.m_142538_(), this.isLit());
        }
    }

    protected void m_7378_(CompoundTag tag) {
        String name = tag.m_128461_("type");
        for (ScarecrowType st : ScarecrowType.TYPES) {
            if (!st.getName().equals(name)) continue;
            this.f_19804_.m_135381_(TYPE, (Object)st);
            break;
        }
        this.f_19804_.m_135381_(LIT, (Object)tag.m_128471_("isLit"));
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(tag.m_128457_("rotation")));
        this.f_19804_.m_135381_(AREA, (Object)new AABB(tag.m_128459_("areaMinX"), tag.m_128459_("areaMinY"), tag.m_128459_("areaMinZ"), tag.m_128459_("areaMaxX"), tag.m_128459_("areaMaxY"), tag.m_128459_("areaMaxZ")));
    }

    protected void m_7380_(CompoundTag tag) {
        AABB area = this.getArea();
        tag.m_128359_("type", this.getScarecrowType().getName());
        tag.m_128379_("isLit", this.isLit());
        tag.m_128350_("rotation", this.getRotation().floatValue());
        tag.m_128347_("areaMinX", area.f_82288_);
        tag.m_128347_("areaMinY", area.f_82289_);
        tag.m_128347_("areaMinZ", area.f_82290_);
        tag.m_128347_("areaMaxX", area.f_82291_);
        tag.m_128347_("areaMaxY", area.f_82292_);
        tag.m_128347_("areaMaxZ", area.f_82293_);
    }

    public ScarecrowType getScarecrowType() {
        return (ScarecrowType)this.f_19804_.m_135370_(TYPE);
    }

    public boolean isLit() {
        return (Boolean)this.f_19804_.m_135370_(LIT);
    }

    public Float getRotation() {
        return (Float)this.f_19804_.m_135370_(ROTATION);
    }

    public AABB getArea() {
        return (AABB)this.f_19804_.m_135370_(AREA);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

