/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="scarecrows")
public class PlaceHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        if (held.m_41720_() == Items.f_42398_) {
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            BlockPos placeAt = pos.m_142300_(face);
            Level world = event.getWorld();
            if (face != Direction.UP && face != Direction.DOWN && ArmBlock.canBeConnectedTo(world.m_8055_(placeAt), (BlockGetter)world, placeAt, face) && world.m_46859_(placeAt)) {
                world.m_46597_(placeAt, (BlockState)Scarecrows.ARM.m_49966_().m_61124_((Property)ArmBlock.FACING, (Comparable)face));
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundType.f_56736_.m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                event.getPlayer().m_6674_(event.getHand());
                if (!event.getPlayer().m_7500_()) {
                    held.m_41774_(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        PlaceHandler.tryBuildScarecrow(event.getWorld(), event.getPos(), event.getPlacedBlock());
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlaceHandler.tryBuildScarecrow((LevelAccessor)event.getWorld(), event.getPos(), event.getWorld().m_8055_(event.getPos()));
    }

    private static void tryBuildScarecrow(LevelAccessor world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50143_ || block == Blocks.f_50144_) {
            for (ScarecrowType type : ScarecrowType.TYPES) {
                Direction pumpkinFacing = (Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_);
                BlockPos groundPos = pos.m_6625_(type.getHeight());
                BlockState groundState = world.m_8055_(groundPos);
                if (groundState.m_60795_() || !type.checkStructure(world, pos, pumpkinFacing)) continue;
                type.destroy(world, pos);
                type.spawn(type, world, pos.m_6625_(type.getHeight() - 1), block == Blocks.f_50144_, pumpkinFacing);
                return;
            }
        }
    }
}

