/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.ai.RunAwayGoal;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="scarecrows")
public class SpawnHandler {
    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        Entity entity = event.getEntity();
        boolean animal = EntityUtil.isAttackableAnimal(entity);
        if (EntityUtil.isAttackableMonster(entity) || animal) {
            List<Scarecrow> scarecrows = ScarecrowTracker.getScarecrowsInRange(level, entity.m_142538_());
            Iterator<Scarecrow> iterator = scarecrows.iterator();
            while (iterator.hasNext()) {
                Predicate filter = e -> e.m_6084_() && ((Mob)entity).m_21574_().m_148306_(e);
                Scarecrow scarecrow = iterator.next();
                if (!filter.apply((Object)scarecrow) || !(entity.m_20270_((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) || !((Mob)entity).m_142582_((Entity)scarecrow)) continue;
                if (animal && scarecrow.getScarecrowType().shouldScareAnimals()) {
                    event.setResult(Event.Result.DENY);
                } else if (!animal) {
                    event.setResult(Event.Result.DENY);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && (EntityUtil.isAttackableMonster((Entity)(mob = (Mob)entity)) || EntityUtil.isAttackableAnimal((Entity)mob))) {
            mob.f_21345_.m_25352_(0, (Goal)new RunAwayGoal(mob));
        }
    }
}

