/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.renderer;

import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ScarecrowRenderer
extends EntityRenderer<Scarecrow> {
    public static final HashMap<String, RenderInfo> RENDER_INFO = new HashMap();

    public ScarecrowRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        for (ScarecrowType type : ScarecrowType.TYPES) {
            RENDER_INFO.put(type.getName(), new RenderInfo(new ResourceLocation("scarecrows", "textures/entity/" + type.getName() + ".png"), type.createModel(ctx.m_174023_(type.getModelLayerLocation(false))), type.createModel(ctx.m_174023_(type.getModelLayerLocation(true)))));
        }
    }

    public void render(Scarecrow entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85837_(0.0, 1.5, 0.0);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(entity.getRotation().floatValue()));
        EntityModel<Scarecrow> modelToRender = entity.isLit() ? RENDER_INFO.get(entity.getScarecrowType().getName()).litModel() : RENDER_INFO.get(entity.getScarecrowType().getName()).unLitModel();
        modelToRender.m_7695_(stack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(Scarecrow entity) {
        return RENDER_INFO.get(entity.getScarecrowType().getName()).textureLocation();
    }

    private record RenderInfo(ResourceLocation textureLocation, EntityModel<Scarecrow> unLitModel, EntityModel<Scarecrow> litModel) {
    }
}

