/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.type;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.entity.Scarecrow;
import bl4ckscor3.mod.scarecrows.type.ScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpoopyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpoopyScarecrow;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ScarecrowType {
    public static final ScarecrowType[] TYPES = new ScarecrowType[]{new SpoopyScarecrow(), new SuperSpoopyScarecrow(), new SpookyScarecrow(), new SuperSpookyScarecrow(), new ScaryScarecrow(), new SuperScaryScarecrow()};
    private String name;
    private int height;
    private int range;
    private boolean scareAnimals;

    public ScarecrowType(String name, int height, int range, boolean scareAnimals) {
        this.name = name;
        this.height = height;
        this.range = range;
        this.scareAnimals = scareAnimals;
    }

    public abstract boolean checkStructure(LevelAccessor var1, BlockPos var2, Direction var3);

    public abstract void destroy(LevelAccessor var1, BlockPos var2);

    public abstract ItemStack[] getDrops();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ModelLayerLocation getModelLayerLocation(boolean var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityModel<Scarecrow> createModel(ModelPart var1);

    public String getName() {
        return this.name;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getRange() {
        return this.range;
    }

    public final boolean shouldScareAnimals() {
        return this.scareAnimals;
    }

    public final boolean hasArms(LevelAccessor world, BlockPos pos, Direction pumpkinFacing) {
        BlockPos posNorth = pos.m_142127_();
        BlockPos posEast = pos.m_142126_();
        BlockPos posSouth = pos.m_142128_();
        BlockPos posWest = pos.m_142125_();
        BlockState stateNorth = world.m_8055_(posNorth);
        BlockState stateEast = world.m_8055_(posEast);
        BlockState stateSouth = world.m_8055_(posSouth);
        BlockState stateWest = world.m_8055_(posWest);
        if ((pumpkinFacing == Direction.EAST || pumpkinFacing == Direction.WEST) && stateNorth.m_60734_() == Scarecrows.ARM && stateNorth.m_61143_((Property)ArmBlock.FACING) == Direction.NORTH && stateSouth.m_60734_() == Scarecrows.ARM && stateSouth.m_61143_((Property)ArmBlock.FACING) == Direction.SOUTH && stateWest.m_60795_() && stateEast.m_60795_()) {
            return true;
        }
        return (pumpkinFacing == Direction.NORTH || pumpkinFacing == Direction.SOUTH) && stateEast.m_60734_() == Scarecrows.ARM && stateEast.m_61143_((Property)ArmBlock.FACING) == Direction.EAST && stateWest.m_60734_() == Scarecrows.ARM && stateWest.m_61143_((Property)ArmBlock.FACING) == Direction.WEST && stateNorth.m_60795_() && stateSouth.m_60795_();
    }

    public final void spawn(ScarecrowType type, LevelAccessor world, BlockPos pos, boolean isLit, Direction facing) {
        if (isLit) {
            ((Level)world).m_46597_(pos.m_6630_(this.height - 1), Scarecrows.INVISIBLE_LIGHT.m_49966_());
        }
        world.m_7967_((Entity)new Scarecrow(type, (Level)world, pos, isLit, facing));
    }

    public final void dropMaterials(Level world, BlockPos pos, boolean dropLight) {
        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)(dropLight ? Blocks.f_50144_ : Blocks.f_50143_)));
        for (ItemStack stack : this.getDrops()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
    }
}

