/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.ai;

import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Particles;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class EntityAIRunAway
extends EntityAIBase {
    private final Predicate<Entity> canBeSeenSelector;
    private EntityLiving entity;
    private final float speed = 1.5f;
    private List<EntityScarecrow> scarecrows = new ArrayList<EntityScarecrow>();
    private Path path;
    private final PathNavigate navigation;
    private long ticksSinceSound = 0L;
    private final Random rand = new Random();

    public EntityAIRunAway(final EntityLiving entity) {
        this.canBeSeenSelector = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity e) {
                return e.func_70089_S() && entity.func_70635_at().func_75522_a(e);
            }
        };
        this.entity = entity;
        this.navigation = entity.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        ArrayList<EntityScarecrow> list = EntityUtil.getLoadedScarecrows(this.entity.field_70170_p, this.canBeSeenSelector);
        if (list.isEmpty()) {
            return false;
        }
        this.scarecrows = list;
        for (EntityScarecrow scarecrow : this.scarecrows) {
            if (EntityUtil.isAttackableMonster((Entity)this.entity)) {
                if (!this.shouldScare(scarecrow)) continue;
                return true;
            }
            if (!scarecrow.getScarecrowType().shouldScareAnimals() || !EntityUtil.isAttackableAnimal((Entity)this.entity) || !this.shouldScare(scarecrow)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldScare(EntityScarecrow scarecrow) {
        List entities = scarecrow.field_70170_p.func_72872_a(this.entity.getClass(), scarecrow.getArea());
        for (EntityLiving e : entities) {
            if (e != this.entity) continue;
            if (e.func_70032_d((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) {
                Vec3d ownPos = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                Vec3d scarecrowPos = new Vec3d(scarecrow.field_70165_t, scarecrow.field_70163_u, scarecrow.field_70161_v);
                Vec3d newPosition = EntityUtil.generateRandomPos(e, 16, 7, ownPos.func_178788_d(scarecrowPos), true);
                if (newPosition == null || scarecrow.func_70092_e(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c) < scarecrow.func_70068_e((Entity)e)) {
                    return false;
                }
                this.path = this.navigation.func_75488_a(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, 1.5);
    }

    public void func_75251_c() {
        this.scarecrows.clear();
    }

    public void updateTask() {
        if (this.ticksSinceSound == 0L) {
            this.entity.func_70642_aH();
            this.entity.func_174830_Y();
            this.ticksSinceSound = 10L;
        } else {
            --this.ticksSinceSound;
        }
        this.createRunningParticles();
        this.entity.func_70661_as().func_75489_a(1.5);
    }

    protected void createRunningParticles() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.entity.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.entity.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.entity.field_70161_v));
        IBlockState iblockstate = this.entity.field_70170_p.func_180495_p(blockpos);
        if (!iblockstate.addRunningEffects(this.entity.field_70170_p, blockpos, (Entity)this.entity) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            this.entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(Particles.field_197611_d, iblockstate), this.entity.field_70165_t + ((double)this.rand.nextFloat() - 0.5) * (double)this.entity.field_70130_N, this.entity.func_174813_aQ().field_72338_b + 0.1, this.entity.field_70161_v + ((double)this.rand.nextFloat() - 0.5) * (double)this.entity.field_70130_N, -this.entity.field_70159_w * 4.0, 1.5, -this.entity.field_70179_y * 4.0);
        }
    }
}

