/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.type;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.BlockArm;
import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import bl4ckscor3.mod.scarecrows.type.ScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SpoopyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperScaryScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpookyScarecrow;
import bl4ckscor3.mod.scarecrows.type.SuperSpoopyScarecrow;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class ScarecrowType {
    public static final ScarecrowType[] TYPES = new ScarecrowType[]{new SpoopyScarecrow(), new SuperSpoopyScarecrow(), new SpookyScarecrow(), new SuperSpookyScarecrow(), new ScaryScarecrow(), new SuperScaryScarecrow()};
    private String name;
    private int height;
    private int range;
    private boolean scareAnimals;

    public ScarecrowType(String name, int height, int range, boolean scareAnimals) {
        this.name = name;
        this.height = height;
        this.range = range;
        this.scareAnimals = scareAnimals;
    }

    public abstract boolean checkStructure(IWorld var1, BlockPos var2, EnumFacing var3);

    public abstract void destroy(IWorld var1, BlockPos var2);

    public abstract ItemStack[] getDrops();

    public abstract ModelBase getModel(boolean var1);

    public String getName() {
        return this.name;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getRange() {
        return this.range;
    }

    public final boolean shouldScareAnimals() {
        return this.scareAnimals;
    }

    public final boolean hasArms(IWorld world, BlockPos pos, EnumFacing pumpkinFacing) {
        BlockPos posNorth = pos.func_177978_c();
        BlockPos posEast = pos.func_177974_f();
        BlockPos posSouth = pos.func_177968_d();
        BlockPos posWest = pos.func_177976_e();
        IBlockState stateNorth = world.func_180495_p(posNorth);
        IBlockState stateEast = world.func_180495_p(posEast);
        IBlockState stateSouth = world.func_180495_p(posSouth);
        IBlockState stateWest = world.func_180495_p(posWest);
        if ((pumpkinFacing == EnumFacing.EAST || pumpkinFacing == EnumFacing.WEST) && stateNorth.func_177230_c() == Scarecrows.ARM && stateNorth.func_177229_b((IProperty)BlockArm.FACING) == EnumFacing.NORTH && stateSouth.func_177230_c() == Scarecrows.ARM && stateSouth.func_177229_b((IProperty)BlockArm.FACING) == EnumFacing.SOUTH && stateWest.isAir((IBlockReader)world, pos) && stateEast.isAir((IBlockReader)world, pos)) {
            return true;
        }
        return (pumpkinFacing == EnumFacing.NORTH || pumpkinFacing == EnumFacing.SOUTH) && stateEast.func_177230_c() == Scarecrows.ARM && stateEast.func_177229_b((IProperty)BlockArm.FACING) == EnumFacing.EAST && stateWest.func_177230_c() == Scarecrows.ARM && stateWest.func_177229_b((IProperty)BlockArm.FACING) == EnumFacing.WEST && stateNorth.isAir((IBlockReader)world, pos) && stateSouth.isAir((IBlockReader)world, pos);
    }

    public final void spawn(ScarecrowType type, IWorld world, BlockPos pos, boolean isLit, EnumFacing facing) {
        if (isLit) {
            ((World)world).func_175656_a(pos.func_177981_b(this.height - 1), Scarecrows.INVISIBLE_LIGHT.func_176223_P());
        }
        world.func_72838_d((Entity)new EntityScarecrow(type, (World)world, pos, isLit, facing));
    }

    public final void dropMaterials(World world, BlockPos pos, boolean dropLight) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)(dropLight ? Blocks.field_196628_cT : Blocks.field_196625_cS)));
        for (ItemStack stack : this.getDrops()) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }
}

