/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.ai;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIRunAway
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = e -> e.func_70089_S() && entity.func_70635_at().func_75522_a(e);
    private MobEntity entity;
    private final float speed = 1.5f;
    private Path path;
    private final PathNavigator navigation;
    private long ticksSinceSound = 0L;

    public EntityAIRunAway(MobEntity entity) {
        this.entity = entity;
        this.navigation = entity.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List<EntityScarecrow> list = ScarecrowTracker.getScarecrowsInRange(this.entity.field_70170_p, this.entity.func_180425_c());
        if (list.isEmpty()) {
            return false;
        }
        for (EntityScarecrow scarecrow : list) {
            if (!this.canBeSeenSelector.apply((Object)scarecrow)) continue;
            if (EntityUtil.isAttackableMonster((Entity)this.entity)) {
                if (!this.shouldScare(scarecrow)) continue;
                return true;
            }
            if (!scarecrow.getScarecrowType().shouldScareAnimals() || !EntityUtil.isAttackableAnimal((Entity)this.entity) || !this.shouldScare(scarecrow)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldScare(EntityScarecrow scarecrow) {
        List entities = scarecrow.field_70170_p.func_217357_a(this.entity.getClass(), scarecrow.getArea());
        for (MobEntity e : entities) {
            if (e != this.entity) continue;
            if (e.func_70032_d((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) {
                Vec3d ownPos = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                Vec3d scarecrowPos = new Vec3d(scarecrow.field_70165_t, scarecrow.field_70163_u, scarecrow.field_70161_v);
                Vec3d newPosition = EntityUtil.generateRandomPos(e, 16, 7, ownPos.func_178788_d(scarecrowPos), true);
                if (newPosition == null || scarecrow.func_70092_e(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c) < scarecrow.func_70068_e((Entity)e)) {
                    return false;
                }
                this.path = this.navigation.func_179680_a(new BlockPos(newPosition), 0);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, 1.5);
    }

    public void func_75246_d() {
        if (this.ticksSinceSound == 0L) {
            this.entity.func_70642_aH();
            this.entity.func_174830_Y();
            this.ticksSinceSound = 10L;
        } else {
            --this.ticksSinceSound;
        }
        this.entity.func_70661_as().func_75489_a(1.5);
    }
}

