/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.entity;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import bl4ckscor3.mod.scarecrows.util.CustomDataSerializers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityScarecrow
extends Entity {
    private static final DataParameter<ScarecrowType> TYPE = EntityDataManager.func_187226_a(EntityScarecrow.class, CustomDataSerializers.SCARECROWTYPE);
    private static final DataParameter<Boolean> LIT = EntityDataManager.func_187226_a(EntityScarecrow.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityScarecrow.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<AxisAlignedBB> AREA = EntityDataManager.func_187226_a(EntityScarecrow.class, CustomDataSerializers.AXISALIGNEDBB);

    public EntityScarecrow(EntityType<EntityScarecrow> type, World world) {
        super(type, world);
    }

    public EntityScarecrow(World world) {
        super(Scarecrows.SCARECROW_ENTITY_TYPE, world);
    }

    public EntityScarecrow(ScarecrowType type, World world, BlockPos pos, boolean isLit, Direction facing) {
        this(world);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
        this.field_70180_af.func_187227_b(LIT, (Object)isLit);
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(facing.func_185119_l() + 180.0f));
        this.field_70180_af.func_187227_b(AREA, (Object)new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b((double)type.getRange(), (double)(type.getHeight() * 3), (double)type.getRange()));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TYPE, null);
        this.field_70180_af.func_187214_a(LIT, (Object)false);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AREA, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        ScarecrowTracker.track(this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        ScarecrowTracker.stopTracking(this);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c().isAir(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()), (IBlockReader)this.field_70170_p, this.func_180425_c())) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isLit()) {
                this.field_70170_p.func_175655_b(this.func_180425_c().func_177981_b(this.getScarecrowType().getHeight() - 1), false);
            }
            this.getScarecrowType().dropMaterials(this.field_70170_p, this.func_180425_c(), this.isLit());
        }
    }

    protected void func_70037_a(CompoundNBT tag) {
        String name = tag.func_74779_i("type");
        for (ScarecrowType st : ScarecrowType.TYPES) {
            if (!st.getName().equals(name)) continue;
            this.field_70180_af.func_187227_b(TYPE, (Object)st);
            break;
        }
        this.field_70180_af.func_187227_b(LIT, (Object)tag.func_74767_n("isLit"));
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(tag.func_74760_g("rotation")));
        this.field_70180_af.func_187227_b(AREA, (Object)new AxisAlignedBB(tag.func_74769_h("areaMinX"), tag.func_74769_h("areaMinY"), tag.func_74769_h("areaMinZ"), tag.func_74769_h("areaMaxX"), tag.func_74769_h("areaMaxY"), tag.func_74769_h("areaMaxZ")));
    }

    protected void func_213281_b(CompoundNBT tag) {
        AxisAlignedBB area = this.getArea();
        tag.func_74778_a("type", this.getScarecrowType().getName());
        tag.func_74757_a("isLit", this.isLit());
        tag.func_74776_a("rotation", this.getRotation().floatValue());
        tag.func_74780_a("areaMinX", area.field_72340_a);
        tag.func_74780_a("areaMinY", area.field_72338_b);
        tag.func_74780_a("areaMinZ", area.field_72339_c);
        tag.func_74780_a("areaMaxX", area.field_72336_d);
        tag.func_74780_a("areaMaxY", area.field_72337_e);
        tag.func_74780_a("areaMaxZ", area.field_72334_f);
    }

    public ScarecrowType getScarecrowType() {
        return (ScarecrowType)this.field_70180_af.func_187225_a(TYPE);
    }

    public boolean isLit() {
        return (Boolean)this.field_70180_af.func_187225_a(LIT);
    }

    public Float getRotation() {
        return (Float)this.field_70180_af.func_187225_a(ROTATION);
    }

    public AxisAlignedBB getArea() {
        return (AxisAlignedBB)this.field_70180_af.func_187225_a(AREA);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

