/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.ai.EntityAIRunAway;
import bl4ckscor3.mod.scarecrows.entity.EntityScarecrow;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="scarecrows")
public class SpawnHandler {
    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        Entity entity = event.getEntity();
        boolean animal = EntityUtil.isAttackableAnimal(entity);
        if (EntityUtil.isAttackableMonster(entity) || animal) {
            List<EntityScarecrow> scarecrows = ScarecrowTracker.getScarecrowsInRange((World)event.getWorld(), entity.func_180425_c());
            Iterator<EntityScarecrow> iterator = scarecrows.iterator();
            while (iterator.hasNext()) {
                Predicate filter = e -> e.func_70089_S() && ((MobEntity)entity).func_70635_at().func_75522_a(e);
                EntityScarecrow scarecrow = iterator.next();
                if (!filter.apply((Object)scarecrow) || !(entity.func_70032_d((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) || !((MobEntity)entity).func_70685_l((Entity)scarecrow)) continue;
                if (animal && scarecrow.getScarecrowType().shouldScareAnimals()) {
                    event.setResult(Event.Result.DENY);
                } else if (!animal) {
                    event.setResult(Event.Result.DENY);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (EntityUtil.isAttackableMonster(event.getEntity()) || EntityUtil.isAttackableAnimal(event.getEntity())) {
            ((MobEntity)event.getEntity()).field_70714_bg.func_75776_a(0, (Goal)new EntityAIRunAway((MobEntity)event.getEntity()));
        }
    }
}

