/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.handler;

import bl4ckscor3.mod.scarecrows.Scarecrows;
import bl4ckscor3.mod.scarecrows.block.ArmBlock;
import bl4ckscor3.mod.scarecrows.type.ScarecrowType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.SoundType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="scarecrows")
public class PlaceHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack held = event.getItemStack();
        if (held.func_77973_b() == Items.field_151055_y) {
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            BlockPos placeAt = pos.func_177972_a(face);
            World world = event.getWorld();
            if (face != Direction.UP && face != Direction.DOWN && Scarecrows.ARM.canBeConnectedTo(world.func_180495_p(placeAt), (IBlockReader)world, placeAt, face) && world.func_175623_d(placeAt)) {
                world.func_175656_a(placeAt, (BlockState)Scarecrows.ARM.func_176223_P().func_206870_a((IProperty)ArmBlock.FACING, (Comparable)face));
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundType.field_185848_a.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.getPlayer().func_184609_a(event.getHand());
                if (!event.getPlayer().func_184812_l_()) {
                    held.func_190918_g(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        PlaceHandler.tryBuildScarecrow(event.getWorld(), event.getPos(), event.getPlacedBlock());
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlaceHandler.tryBuildScarecrow((IWorld)event.getWorld(), event.getPos(), event.getWorld().func_180495_p(event.getPos()));
    }

    private static void tryBuildScarecrow(IWorld world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_196625_cS || block == Blocks.field_196628_cT) {
            for (ScarecrowType type : ScarecrowType.TYPES) {
                Direction pumpkinFacing = (Direction)state.func_177229_b((IProperty)CarvedPumpkinBlock.field_196359_a);
                BlockPos groundPos = pos.func_177979_c(type.getHeight());
                BlockState groundState = world.func_180495_p(groundPos);
                if (groundState.func_177230_c().isAir(groundState, (IBlockReader)world, groundPos) || !type.checkStructure(world, pos, pumpkinFacing)) continue;
                type.destroy(world, pos);
                type.spawn(type, world, pos.func_177979_c(type.getHeight() - 1), block == Blocks.field_196628_cT, pumpkinFacing);
                return;
            }
        }
    }
}

