/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.scarecrows.ai;

import bl4ckscor3.mod.scarecrows.ScarecrowTracker;
import bl4ckscor3.mod.scarecrows.entity.ScarecrowEntity;
import bl4ckscor3.mod.scarecrows.util.EntityUtil;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class RunAwayGoal
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = e -> e.func_70089_S() && entity.func_70635_at().func_75522_a(e);
    private MobEntity entity;
    private final float speed = 1.5f;
    private Path path;
    private final PathNavigator navigation;
    private long ticksSinceSound = 0L;

    public RunAwayGoal(MobEntity entity) {
        this.entity = entity;
        this.navigation = entity.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List<ScarecrowEntity> list = ScarecrowTracker.getScarecrowsInRange(this.entity.field_70170_p, this.entity.func_233580_cy_());
        if (list.isEmpty()) {
            return false;
        }
        for (ScarecrowEntity scarecrow : list) {
            if (!this.canBeSeenSelector.apply((Object)scarecrow)) continue;
            if (EntityUtil.isAttackableMonster((Entity)this.entity)) {
                if (!this.shouldScare(scarecrow)) continue;
                return true;
            }
            if (!scarecrow.getScarecrowType().shouldScareAnimals() || !EntityUtil.isAttackableAnimal((Entity)this.entity) || !this.shouldScare(scarecrow)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldScare(ScarecrowEntity scarecrow) {
        List entities = scarecrow.field_70170_p.func_217357_a(this.entity.getClass(), scarecrow.getArea());
        for (MobEntity e : entities) {
            if (e != this.entity) continue;
            if (e.func_70032_d((Entity)scarecrow) <= (float)scarecrow.getScarecrowType().getRange()) {
                Vector3d scarecrowPos = new Vector3d(scarecrow.func_226277_ct_(), scarecrow.func_226278_cu_(), scarecrow.func_226281_cx_());
                Vector3d ownPos = new Vector3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
                Vector3d newPosition = EntityUtil.generateRandomPos(e, 16, 7, ownPos.func_178788_d(scarecrowPos), true);
                if (newPosition == null || scarecrow.func_70092_e(newPosition.field_72450_a, newPosition.field_72448_b, newPosition.field_72449_c) < scarecrow.func_70068_e((Entity)e)) {
                    return false;
                }
                this.path = this.navigation.func_179680_a(new BlockPos(newPosition), 0);
                return this.path != null;
            }
            return false;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, 1.5);
    }

    public void func_75246_d() {
        if (this.ticksSinceSound == 0L) {
            this.entity.func_70642_aH();
            this.createRunningParticles((Entity)this.entity);
            this.ticksSinceSound = 10L;
        } else {
            --this.ticksSinceSound;
        }
        this.entity.func_70661_as().func_75489_a(1.5);
    }

    private void createRunningParticles(Entity entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(entity.func_226278_cu_() - (double)0.2f)), z = MathHelper.func_76128_c((double)entity.func_226281_cx_()));
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        if (!state.addRunningEffects(entity.field_70170_p, pos, entity) && state.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d motion = entity.func_213322_ci();
            EntitySize size = entity.func_213305_a(entity.func_213283_Z());
            Random rand = entity.field_70170_p.field_73012_v;
            entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state).setPos(pos), entity.func_226277_ct_() + (rand.nextDouble() - 0.5) * (double)size.field_220315_a, entity.func_226278_cu_() + 0.1, entity.func_226281_cx_() + (rand.nextDouble() - 0.5) * (double)size.field_220315_a, motion.field_72450_a * -4.0, 1.5, motion.field_72449_c * -4.0);
        }
    }
}

