/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.core.SereneSeasons;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;

@Mod.EventBusSubscriber
public class TimeSkipHandler {
    private long lastDayTime = -1L;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            long difference;
            ServerWorld world = (ServerWorld)event.world;
            long dayTime = world.func_72912_H().func_76073_f();
            if (this.lastDayTime == -1L) {
                this.lastDayTime = dayTime;
            }
            if ((difference = world.func_72912_H().func_76073_f() - this.lastDayTime) < 0L) {
                difference += 24000L;
            }
            if (difference > 1L) {
                SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((World)world);
                seasonData.seasonCycleTicks = (int)((long)seasonData.seasonCycleTicks + difference);
                seasonData.func_76185_a();
                SeasonHandler.sendSeasonUpdate((World)world);
                SereneSeasons.logger.info("Season time skipped by " + difference);
            }
            this.lastDayTime = dayTime;
        }
    }
}

