/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonTime;

public class SeasonHooks {
    public static float getBiomeTemperatureCachedHook(Biome biome, BlockPos pos, IWorldReader world) {
        if (!(world instanceof World)) {
            return biome.func_225486_c(pos);
        }
        return SeasonHooks.getBiomeTemperature((World)world, biome, pos);
    }

    public static float getBiomeTemperature(World world, Biome biome, BlockPos pos) {
        if (!SeasonsConfig.isDimensionWhitelisted(world.func_201675_m().func_186058_p().func_186068_a())) {
            return biome.func_225486_c(pos);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(world).getSeasonCycleTicks()).getSubSeason(), biome, pos);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, Biome biome, BlockPos pos) {
        boolean tropicalBiome = BiomeConfig.usesTropicalSeasons(biome);
        float biomeTemp = biome.func_225486_c(pos);
        if (!tropicalBiome && biome.func_185353_n() <= 0.8f && BiomeConfig.enablesSeasonalEffects(biome)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }
}

