/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.util;

import enemeez.simplefarming.SimpleFarming;
import enemeez.simplefarming.block.growable.SimpleCropBlock;
import enemeez.simplefarming.config.FeatureConfig;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.MarkerManager;

public abstract class CropHarvestUtil {
    public static final Tag<Item> DENY_RIGHT_CLICK_HARVEST_TAG = new ItemTags.Wrapper(new ResourceLocation("simplefarming", "deny_right_click_harvest"));
    private static final Method GET_SEED_ITEM = ObfuscationReflectionHelper.findMethod(CropsBlock.class, (String)"func_199772_f", (Class[])new Class[0]);

    public static boolean isItemNotDenyingHarvest(Item item) {
        return !DENY_RIGHT_CLICK_HARVEST_TAG.func_199685_a_((Object)item);
    }

    @Nullable
    public static Item getCropSeedItem(Block block) {
        if (block instanceof SimpleCropBlock) {
            return ((SimpleCropBlock)block).func_199772_f().func_199767_j();
        }
        try {
            return (Item)GET_SEED_ITEM.invoke((Object)block, new Object[0]);
        }
        catch (Exception e) {
            SimpleFarming.LOGGER.error(MarkerManager.getMarker((String)"CropHarvest"), "couldn't find seed item", (Throwable)e);
            return null;
        }
    }

    public static void dropLoot(ServerWorld world, PlayerEntity player, BlockState state, BlockPos pos) {
        CropHarvestUtil.dropLootExceptItem(world, player, state, pos, null, ((FeatureConfig.RightClickHarvestFeature)((Object)FeatureConfig.rightClickHarvest.get())).isSmartHarvest());
    }

    public static void dropLootExceptItem(ServerWorld world, PlayerEntity player, BlockState state, BlockPos pos, @Nullable Item denyItem) {
        CropHarvestUtil.dropLootExceptItem(world, player, state, pos, denyItem, ((FeatureConfig.RightClickHarvestFeature)((Object)FeatureConfig.rightClickHarvest.get())).isSmartHarvest());
    }

    public static void dropLootExceptItem(ServerWorld world, PlayerEntity player, BlockState state, BlockPos pos, @Nullable Item denyItem, boolean addLootToPlayerInv) {
        List drops = Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
        for (ItemStack stack : drops) {
            if (stack.func_77973_b() == denyItem || addLootToPlayerInv && player.func_191521_c(stack)) continue;
            world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
    }

    public static int dropLootExceptOneSeed(ServerWorld world, PlayerEntity player, BlockState state, BlockPos pos, @Nullable Item seedItem) {
        return CropHarvestUtil.dropLootExceptOneSeed(world, player, state, pos, seedItem, ((FeatureConfig.RightClickHarvestFeature)((Object)FeatureConfig.rightClickHarvest.get())).isSmartHarvest());
    }

    public static int dropLootExceptOneSeed(ServerWorld world, PlayerEntity player, BlockState state, BlockPos pos, @Nullable Item seedItem, boolean addLootToPlayerInv) {
        List drops = Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
        int seedCount = drops.stream().filter(stack -> stack.func_77973_b() == seedItem).mapToInt(ItemStack::func_190916_E).sum();
        for (ItemStack stack2 : drops) {
            if (stack2.func_190926_b()) continue;
            Item itemDrop = stack2.func_77973_b();
            if (itemDrop == seedItem) {
                if (seedCount <= 0) continue;
                if (seedCount - stack2.func_190916_E() < 1) {
                    stack2.func_190918_g(1);
                }
                if (stack2.func_190926_b()) continue;
                seedCount -= stack2.func_190916_E();
                if (addLootToPlayerInv && player.func_191521_c(stack2)) continue;
                world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack2));
                continue;
            }
            if (addLootToPlayerInv && player.func_191521_c(stack2)) continue;
            world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack2));
        }
        return seedCount;
    }
}

