/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class LargePlaneEntity
extends PlaneEntity {
    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, World worldIn, double x, double y, double z) {
        super(entityTypeIn, worldIn, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        for (Entity entity : list) {
            if (this.field_70170_p.field_72995_K || this.func_184179_bs() instanceof PlayerEntity || entity.func_184196_w((Entity)this) || this.func_184188_bt().size() >= 2 || entity.func_184218_aH() || !(entity instanceof LivingEntity) || entity instanceof PlayerEntity) continue;
            entity.func_184220_m((Entity)this);
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        if (this.func_184188_bt().size() > 1 || passenger.func_184187_bx() == this) {
            return false;
        }
        if (this.func_184188_bt().size() == 1) {
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!upgrade.getType().occupyBackSeat) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        List passengers = this.func_184188_bt();
        if (passengers.size() > 1) {
            super.func_184232_k(passenger);
            if (passengers.indexOf(passenger) != 0) {
                Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(super.func_70042_X() + passenger.func_70033_W()), -1.0f));
                passenger.func_70107_b(this.func_226277_ct_() + (double)pos.func_195899_a(), this.func_226278_cu_() + (double)pos.func_195900_b(), this.func_226281_cx_() + (double)pos.func_195902_c());
            }
        } else {
            super.func_184232_k(passenger);
        }
    }

    @Override
    protected void spawnSmokeParticles(int fuel) {
        Vector2f front = this.getHorizontalFrontPos();
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() - (double)(2.0f * front.field_189982_i), this.func_226278_cu_() + 1.0, this.func_226281_cx_() - (double)(2.0f * front.field_189983_j), 0, 0.0, 0.0, 0.0, 0.0);
        if (fuel > 4 && fuel < 100) {
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_() + (double)front.field_189982_i, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + (double)front.field_189983_j, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.occupyBackSeat) {
            if (this.func_184188_bt().size() > 1) {
                return false;
            }
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!upgrade.getType().occupyBackSeat) continue;
                return false;
            }
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && upgradeType.isPlaneApplicable.test(this);
    }

    @Override
    public boolean isLarge() {
        return true;
    }
}

