/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.GameRules;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.przemyk.simpleplanes.Config;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.entities.AbstractPlaneEntityType;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.rocket.RocketUpgrade;

public class PlaneEntity
extends Entity
implements IJumpingMount {
    protected static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final EntitySize FLYING_SIZE = EntitySize.func_220314_b((float)2.0f, (float)1.5f);
    public static final EntitySize FLYING_SIZE_EASY = EntitySize.func_220314_b((float)2.0f, (float)2.0f);
    public static final DataParameter<Integer> MOVEMENT_RIGHT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Quaternion> Q = EntityDataManager.func_187226_a(PlaneEntity.class, SimplePlanesDataSerializers.QUATERNION_SERIALIZER);
    public Quaternion Q_Client = new Quaternion(Quaternion.field_227060_a_);
    public Quaternion Q_Prev = new Quaternion(Quaternion.field_227060_a_);
    public static final DataParameter<CompoundNBT> UPGRADES_NBT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    public static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 0.5, 1.0);
    protected int poweredTicks;
    private int groundTicks;
    public HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.field_70138_W = 0.9999f;
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn, double x, double y, double z) {
        this(entityTypeIn, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
        this.field_70180_af.func_187214_a(MOVEMENT_RIGHT, (Object)0);
        this.field_70180_af.func_187214_a(UPGRADES_NBT, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(Q, (Object)Quaternion.field_227060_a_);
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(0.25f));
    }

    public void addFuel() {
        this.addFuel((Integer)Config.FLY_TICKS_PER_COAL.get());
    }

    public void addFuel(Integer fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)Math.max(this.getFuel(), fuel));
    }

    public int getFuel() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL);
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float max_speed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(max_speed));
    }

    public Quaternion getQ() {
        return new Quaternion((Quaternion)this.field_70180_af.func_187225_a(Q));
    }

    public void setQ(Quaternion q) {
        this.field_70180_af.func_187227_b(Q, (Object)q);
    }

    public Quaternion getQ_Client() {
        return new Quaternion(this.Q_Client);
    }

    public void setQ_Client(Quaternion q) {
        this.Q_Client = q;
    }

    public Quaternion getQ_Prev() {
        return this.Q_Prev.func_227068_g_();
    }

    public void setQ_prev(Quaternion q) {
        this.Q_Prev = q;
    }

    public boolean isPowered() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL) > 0 || this.isCreative();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.tryToAddUpgrade(player, player.func_184586_b(hand))) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b()) {
            boolean hasplayer = false;
            for (Entity passenger : this.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity)) continue;
                hasplayer = true;
                break;
            }
            if (!hasplayer || ((Boolean)Config.THIEF.get()).booleanValue()) {
                this.func_184226_ay();
            }
            return ActionResultType.SUCCESS;
        }
        return !this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public boolean tryToAddUpgrade(PlayerEntity player, ItemStack itemStack) {
        for (UpgradeType upgradeType : SimplePlanesRegistries.UPGRADE_TYPES.getValues()) {
            if (!upgradeType.IsThisItem(itemStack) || !this.canAddUpgrade(upgradeType)) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.onApply(itemStack, player);
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            this.upgrades.put(upgradeType.getRegistryName(), upgrade);
            this.upgradeChanged();
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d || !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g) || this.field_70128_L)) {
            this.dropItem();
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    protected void dropItem() {
        ItemStack itemStack = new ItemStack((IItemProvider)((AbstractPlaneEntityType)this.func_200600_R()).dropItem);
        if (this.upgrades.containsKey(SimplePlanesUpgrades.FOLDING.getId())) {
            itemStack.func_77983_a("EntityTag", (INBT)this.serializeNBT());
        } else {
            for (Upgrade upgrade : this.upgrades.values()) {
                ItemStack item = upgrade.getItem();
                if (item == null) continue;
                this.func_199701_a_(item);
            }
        }
        this.func_199701_a_(itemStack);
    }

    public Vector2f getHorizontalFrontPos() {
        return new Vector2f(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (Boolean)Config.EASY_FLIGHT.get() != false ? FLYING_SIZE_EASY : FLYING_SIZE;
        }
        return super.func_213305_a(poseIn);
    }

    public void func_70071_h_() {
        float pitch;
        Vector3d motion;
        float moveStrafing;
        LivingEntity controllingPassenger;
        super.func_70071_h_();
        if (Double.isNaN(this.func_213322_ci().func_72433_c())) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.prevRotationRoll = this.rotationRoll;
        if (this.isPowered()) {
            if (this.poweredTicks % 50 == 0) {
                this.func_184185_a((SoundEvent)SimplePlanesSounds.PLANE_LOOP.get(), 0.05f, 1.0f);
            }
            ++this.poweredTicks;
        } else {
            this.poweredTicks = 0;
        }
        if (this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            this.tickLerp();
            this.func_213317_d(Vector3d.field_186680_a);
            MathUtil.Angels angels1 = MathUtil.toEulerAngles(this.getQ_Client());
            this.field_70125_A = (float)angels1.pitch;
            this.field_70177_z = (float)angels1.yaw;
            this.rotationRoll = (float)angels1.roll;
            float d = MathUtil.func_203302_c((float)this.field_70126_B, (float)this.field_70177_z);
            if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
                d = 0.0f;
            }
            this.deltaRotationLeft += d;
            this.deltaRotationLeft = MathHelper.func_76142_g((float)this.deltaRotationLeft);
            int diff = 5;
            this.deltaRotation = Math.min(MathUtil.func_76135_e((float)this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
            this.deltaRotationLeft -= this.deltaRotation;
            return;
        }
        double max_speed = 3.0;
        double max_push_speed = this.getMaxSpeed() * 10.0f;
        double take_off_speed = 0.3;
        float max_lift = 2.0f;
        double lift_factor = 10.0;
        double gravity = -0.03;
        double drag = 0.002;
        double drag_mul = 5.0E-4;
        double drag_quad = 0.001;
        float push = 0.06f;
        float ground_push = 0.01f;
        float passive_engine_push = 0.025f;
        float motion_to_rotation = 0.05f;
        float pitch_to_motion = 0.2f;
        if (this.func_189652_ae()) {
            gravity = 0.0;
            max_lift = 0.0f;
            push = 0.0f;
            passive_engine_push = 0.0f;
        }
        float moveForward = (controllingPassenger = (LivingEntity)this.func_184179_bs()) instanceof PlayerEntity ? controllingPassenger.field_191988_bg : 0.0f;
        double turn_threshold = (double)((Integer)Config.TURN_THRESHOLD.get()).intValue() / 100.0;
        if ((double)MathUtil.func_76135_e((float)moveForward) < turn_threshold) {
            moveForward = 0.0f;
        }
        float f = moveStrafing = controllingPassenger instanceof PlayerEntity ? controllingPassenger.field_70702_br : 0.0f;
        if ((double)MathUtil.func_76135_e((float)moveStrafing) < turn_threshold) {
            moveStrafing = 0.0f;
        }
        boolean passengerSprinting = controllingPassenger != null && controllingPassenger.func_70051_ag();
        Boolean easy = (Boolean)Config.EASY_FLIGHT.get();
        Quaternion q = this.field_70170_p.field_72995_K ? this.getQ_Client() : this.getQ();
        MathUtil.Angels angelsOld = MathUtil.toEulerAngles(q).copy();
        Vector3d oldMotion = this.func_213322_ci();
        this.func_213323_x_();
        int fuel = (Integer)this.field_70180_af.func_187225_a(FUEL);
        if (fuel > 0) {
            this.field_70180_af.func_187227_b(FUEL, (Object)(fuel -= passengerSprinting ? 4 : 1));
        }
        if ((motion = this.func_213322_ci()).func_72433_c() > 0.05) {
            float d;
            float yaw = MathUtil.getYaw(motion);
            pitch = MathUtil.getPitch(motion);
            if (MathUtil.func_203301_d((float)yaw, (float)this.field_70177_z) > 5.0f && (this.getOnGround() || this.isAboveWater())) {
                this.func_213317_d(motion.func_186678_a(0.98));
            }
            if ((d = MathUtil.func_203301_d((float)pitch, (float)this.field_70125_A)) > 180.0f) {
                d -= 180.0f;
            }
            d /= 60.0f;
            d = Math.min(1.0f, d);
            d *= d;
            d = 1.0f - d;
            double speed = this.func_213322_ci().func_72433_c();
            double lift = Math.min(speed * lift_factor, (double)max_lift) * (double)d;
            double cos_roll = (1.0 + 4.0 * Math.max(Math.cos(Math.toRadians(MathUtil.func_203301_d((float)this.rotationRoll, (float)0.0f))), 0.0)) / 5.0;
            d = (float)((double)d * cos_roll);
            this.func_213317_d(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.field_70177_z), (double)MathUtil.lerpAngle180(pitch_to_motion * d, pitch, this.field_70125_A) + (lift *= cos_roll), speed));
            if (!this.getOnGround() && !this.isAboveWater() && motion.func_72433_c() > 0.1) {
                if (MathUtil.func_203301_d((float)pitch, (float)this.field_70125_A) > 90.0f) {
                    pitch = MathHelper.func_76142_g((float)(pitch + 180.0f));
                }
                if (Math.abs(this.field_70125_A) < 85.0f) {
                    yaw = MathUtil.getYaw(this.func_213322_ci());
                    if (MathUtil.func_203301_d((float)yaw, (float)this.field_70177_z) > 90.0f) {
                        yaw -= 180.0f;
                    }
                    Quaternion q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                    q = MathUtil.lerpQ(motion_to_rotation, q, q1);
                }
            }
        }
        boolean b = true;
        if (this.getOnGround() || this.isAboveWater()) {
            this.groundTicks = this.groundTicks < 0 ? 5 : --this.groundTicks;
            float f2 = pitch = this.isLarge() ? 10.0f : 15.0f;
            if (this.isPowered() && moveForward > 0.0f || this.isAboveWater()) {
                pitch = 0.0f;
            } else if (this.func_213322_ci().func_72433_c() > take_off_speed) {
                pitch /= 2.0f;
            }
            this.field_70125_A = MathUtil.lerpAngle(0.1f, this.field_70125_A, pitch);
            if (MathUtil.func_203301_d((float)this.field_70125_A, (float)0.0f) > 1.0f && this.func_213322_ci().func_72433_c() < 0.1) {
                push = 0.0f;
            }
            if (this.func_213322_ci().func_72433_c() < take_off_speed) {
                b = false;
            }
            if (moveForward < 0.0f) {
                push = -ground_push;
            }
            if (!this.isPowered() || moveForward == 0.0f) {
                push = 0.0f;
            }
            BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            float f3 = this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this);
            drag_mul *= (double)(20.0f * (3.0f - f3));
        } else if (!passengerSprinting) {
            push = passive_engine_push;
        }
        --this.groundTicks;
        pitch = 0.0f;
        if (moveForward > 0.0f) {
            pitch = passengerSprinting ? 2.0f : 1.0f;
        } else if (moveForward < 0.0f) {
            float f4 = pitch = passengerSprinting ? -2.0f : -1.0f;
        }
        if (!this.isPowered()) {
            push = 0.0f;
        }
        if (b) {
            this.field_70125_A += pitch;
        }
        motion = this.func_213322_ci();
        double speed = motion.func_72433_c();
        double speed_x = MathUtil.getHorizontalLength(motion);
        speed -= speed * speed * drag_quad + speed * drag_mul + 0.002;
        if ((speed = Math.max(speed, 0.0)) > max_speed) {
            speed = MathUtil.func_219803_d((double)0.2, (double)speed, (double)max_speed);
        }
        if (push != 0.0f) {
            push = (float)((double)push * Math.max(1.0 - speed / (max_push_speed * ((double)push + 0.05)), 0.0));
        }
        if (speed == 0.0) {
            motion = Vector3d.field_186680_a;
        }
        if (motion.func_72433_c() > 0.0) {
            motion = motion.func_186678_a(speed / motion.func_72433_c());
        }
        Vector3f v = this.transformPos(new Vector3f(0.0f, 0.0f, push));
        motion = motion.func_72441_c((double)v.func_195899_a(), (double)v.func_195900_b(), (double)v.func_195902_c());
        motion = motion.func_72441_c(0.0, gravity, 0.0);
        this.func_213317_d(motion);
        float f1 = 1.0f;
        double turn = 0.0;
        if (this.getOnGround() || this.isAboveWater() || !passengerSprinting || easy.booleanValue()) {
            int yawdiff = 2;
            float roll = this.rotationRoll;
            if (MathUtil.func_203301_d((float)this.field_70125_A, (float)0.0f) < 45.0f) {
                for (int i = 0; i < 360; i += 180) {
                    if (!(MathHelper.func_203301_d((float)this.rotationRoll, (float)i) < 80.0f)) continue;
                    roll = MathUtil.lerpAngle(0.1f * f1, this.rotationRoll, i);
                    break;
                }
            }
            int r = 15;
            if (this.getOnGround() || this.isAboveWater()) {
                turn = moveStrafing > 0.0f ? (double)yawdiff : (moveStrafing == 0.0f ? 0.0 : (double)(-yawdiff));
                this.rotationRoll = roll;
            } else if (MathUtil.func_203301_d((float)this.rotationRoll, (float)0.0f) > 30.0f) {
                turn = moveStrafing > 0.0f ? (double)(-yawdiff) : (moveStrafing == 0.0f ? 0.0 : (double)yawdiff);
                this.rotationRoll = roll;
            } else {
                if (moveStrafing == 0.0f) {
                    this.rotationRoll = MathUtil.lerpAngle180(0.2f, this.rotationRoll, 0.0f);
                } else if (moveStrafing > 0.0f) {
                    this.rotationRoll = MathUtil.func_76131_a((float)(this.rotationRoll + f1), (float)0.0f, (float)r);
                } else if (moveStrafing < 0.0f) {
                    this.rotationRoll = MathUtil.func_76131_a((float)(this.rotationRoll - f1), (float)(-r), (float)0.0f);
                }
                double roll_old = MathUtil.toEulerAngles((Quaternion)this.getQ()).roll;
                turn = MathUtil.degreesDifferenceAbs(roll_old, 0.0) < 90.0 ? MathHelper.func_151237_a((double)(roll_old / 5.0), (double)(-yawdiff), (double)yawdiff) : MathHelper.func_151237_a((double)((180.0 - roll_old) / 5.0), (double)(-yawdiff), (double)yawdiff);
                if (moveStrafing == 0.0f) {
                    turn = 0.0;
                }
            }
        } else if (moveStrafing == 0.0f) {
            for (int i = 0; i < 360; i += 180) {
                if (!(MathHelper.func_203301_d((float)this.rotationRoll, (float)i) < 80.0f)) continue;
                this.rotationRoll = MathUtil.lerpAngle(0.01f * f1, this.rotationRoll, i);
                break;
            }
        } else if (moveStrafing > 0.0f) {
            this.rotationRoll += f1;
        } else if (moveStrafing < 0.0f) {
            this.rotationRoll -= f1;
        }
        this.field_70177_z = (float)((double)this.field_70177_z - turn);
        HashSet<Upgrade> upgradesToRemove = new HashSet<Upgrade>();
        for (Upgrade upgrade : this.upgrades.values()) {
            if (!upgrade.tick()) continue;
            upgradesToRemove.add(upgrade);
        }
        for (Upgrade upgrade : upgradesToRemove) {
            this.upgrades.remove(upgrade.getType().getRegistryName());
        }
        double l = 0.002;
        if (oldMotion.func_72433_c() < l && this.func_213322_ci().func_72433_c() < l) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.func_213323_x_();
        this.func_226264_Z_();
        if (!this.field_70122_E || PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            double speed_after;
            double speed_diff;
            float f2;
            double speed_before = Math.sqrt(PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci()));
            boolean onGroundOld = this.field_70122_E;
            if (this.func_213322_ci().func_72433_c() > 0.5 || moveForward != 0.0f) {
                this.field_70122_E = true;
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            boolean bl = this.field_70122_E = motion.func_82617_b() == 0.0 ? onGroundOld : this.field_70122_E;
            if (this.field_70123_F && !this.field_70170_p.field_72995_K && ((Boolean)Config.PLANE_CRUSH.get()).booleanValue() && this.groundTicks <= 0 && (f2 = (float)((speed_diff = speed_before - (speed_after = Math.sqrt(PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci())))) * 10.0 - 5.0)) > 5.0f) {
                this.crush(f2);
            }
        }
        if (this.isPowered() && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K) {
            this.spawnSmokeParticles(fuel);
        }
        q.func_195890_a(new Quaternion(Vector3f.field_229183_f_, (float)((double)this.rotationRoll - angelsOld.roll), true));
        q.func_195890_a(new Quaternion(Vector3f.field_229178_a_, (float)((double)this.field_70125_A - angelsOld.pitch), true));
        q.func_195890_a(new Quaternion(Vector3f.field_229181_d_, (float)((double)this.field_70177_z - angelsOld.yaw), true));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        MathUtil.Angels angels1 = MathUtil.toEulerAngles(q);
        this.field_70125_A = (float)angels1.pitch;
        this.field_70177_z = (float)angels1.yaw;
        this.rotationRoll = (float)angels1.roll;
        float d = MathUtil.func_203302_c((float)this.field_70126_B, (float)this.field_70177_z);
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = MathHelper.func_76142_g((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(MathUtil.func_76135_e((float)this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
        if (this.field_70170_p.field_72995_K && this.func_184186_bw()) {
            this.setQ_Client(q);
            PlaneNetworking.INSTANCE.sendToServer((Object)this.getQ());
        }
        this.tickLerp();
    }

    protected void spawnSmokeParticles(int fuel) {
        this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, new Vector3f(0.0f, 0.8f, -1.0f), 0);
        if (fuel > 4 && fuel < 100) {
            this.spawnParticle((IParticleData)ParticleTypes.field_197594_E, new Vector3f(0.0f, 0.8f, -1.0f), 5);
        }
    }

    public void spawnParticle(IParticleData particleData, Vector3f relPos, int particleCount) {
        relPos = new Vector3f(relPos.func_195899_a(), relPos.func_195900_b() - 0.3f, relPos.func_195902_c());
        relPos = this.transformPos(relPos);
        relPos = new Vector3f(relPos.func_195899_a(), relPos.func_195900_b() + 0.9f, relPos.func_195902_c());
        ((ServerWorld)this.field_70170_p).func_195598_a(particleData, this.func_226277_ct_() + (double)relPos.func_195899_a(), this.func_226278_cu_() + (double)relPos.func_195900_b(), this.func_226281_cx_() + (double)relPos.func_195902_c(), particleCount, 0.0, 0.0, 0.0, 0.0);
    }

    public Vector3f transformPos(Vector3f relPos) {
        MathUtil.Angels angels = MathUtil.toEulerAngles(this.getQ_Client());
        angels.yaw = -angels.yaw;
        angels.roll = -angels.roll;
        relPos.func_214905_a(MathUtil.toQuaternion(angels.yaw, angels.pitch, angels.roll));
        return relPos;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(FUEL, (Object)compound.func_74762_e("Fuel"));
        CompoundNBT upgradesNBT = compound.func_74775_l("upgrades");
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)upgradesNBT);
        this.deserializeUpgrades(upgradesNBT);
    }

    private void deserializeUpgrades(CompoundNBT upgradesNBT) {
        for (String key : upgradesNBT.func_150296_c()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.func_74775_l(key));
            this.upgrades.put(resourceLocation, upgrade);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Fuel", ((Integer)this.field_70180_af.func_187225_a(FUEL)).intValue());
        compound.func_218657_a("upgrades", (INBT)this.getUpgradesNBT());
    }

    private CompoundNBT getUpgradesNBT() {
        CompoundNBT upgradesNBT = new CompoundNBT();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.func_218657_a(upgrade.getType().getRegistryName().toString(), (INBT)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATING.getId());
    }

    public boolean func_70067_L() {
        return true;
    }

    protected AxisAlignedBB func_213321_d(Pose pose) {
        return COLLISION_AABB.func_191194_a(this.func_213303_ch());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (UPGRADES_NBT.equals(key) && this.field_70170_p.func_201670_d()) {
            this.deserializeUpgrades((CompoundNBT)this.field_70180_af.func_187225_a(UPGRADES_NBT));
        }
        if (Q.equals(key) && this.field_70170_p.func_201670_d() && !this.func_184186_bw()) {
            if (this.field_70148_d) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double func_70042_X() {
        return 0.375;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76346_g() != null && source.func_76346_g().func_184223_x((Entity)this)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if ((onGroundIn || this.isAboveWater()) && ((Boolean)Config.PLANE_CRUSH.get()).booleanValue()) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).func_195900_b();
            if (y1 < 0.867) {
                this.crush((float)(this.func_213322_ci().func_72433_c() * 5.0));
            }
            this.field_70143_R = 0.0f;
        }
    }

    private void crush(float damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_70097_a(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage);
            }
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.dropItem();
            }
            this.func_70106_y();
        }
    }

    public boolean isCreative() {
        return this.func_184179_bs() instanceof PlayerEntity && ((PlayerEntity)this.func_184179_bs()).func_184812_l_();
    }

    public boolean getOnGround() {
        return this.field_70122_E || this.groundTicks > 1;
    }

    public boolean isAboveWater() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.func_213303_ch().func_72441_c(0.0, 0.4, 0.0))).func_177230_c() == Blocks.field_150355_j;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && !upgradeType.occupyBackSeat && upgradeType.isPlaneApplicable.test(this);
    }

    public boolean isLarge() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        boolean b;
        super.func_184232_k(passenger);
        boolean bl = b = passenger instanceof PlayerEntity && ((PlayerEntity)passenger).func_175144_cb();
        if (this.func_184196_w(passenger) && !b) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_70034_d(entityToUpdate.func_70079_am() + this.deltaRotation);
        entityToUpdate.field_70177_z += this.deltaRotation;
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        float perc = this.deltaRotationTicks > 0 ? 1.0f / (float)this.deltaRotationTicks : 1.0f;
        float diff = (f1 - f) * perc;
        entityToUpdate.field_70126_B += diff;
        entityToUpdate.field_70177_z += diff;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        double d1;
        Vector3d vector3d = PlaneEntity.func_233559_a_((double)(this.func_213311_cf() * MathHelper.field_180189_a), (double)p_230268_1_.func_213311_cf(), (float)this.field_70177_z);
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        BlockPos blockpos = new BlockPos(d0, this.func_174813_aQ().field_72337_e, d1 = this.func_226281_cx_() + vector3d.field_72449_c);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.field_70170_p.func_201671_F(blockpos1)) {
            double d2 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos);
            double d3 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos1);
            for (Pose pose : p_230268_1_.func_230297_ef_()) {
                Vector3d vector3d1 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d2, (double)d1, (LivingEntity)p_230268_1_, (Pose)pose);
                if (vector3d1 != null) {
                    p_230268_1_.func_213301_b(pose);
                    return vector3d1;
                }
                Vector3d vector3d2 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d3, (double)d1, (LivingEntity)p_230268_1_, (Pose)pose);
                if (vector3d2 == null) continue;
                p_230268_1_.func_213301_b(pose);
                return vector3d2;
            }
        }
        return super.func_230268_c_(p_230268_1_);
    }

    private ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack((IItemProvider)((AbstractPlaneEntityType)this.func_200600_R()).dropItem);
        if (this.upgrades.containsKey(SimplePlanesUpgrades.FOLDING.getId())) {
            itemStack.func_77983_a("EntityTag", (INBT)this.serializeNBT());
            itemStack.func_77966_a(Enchantments.field_185296_A, 1);
        }
        return itemStack;
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.func_226277_ct_() && y == this.func_226278_cu_() && z == this.func_226281_cx_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        double d0 = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_70169_q = d0;
        this.field_70167_r = y;
        this.field_70166_s = d1;
        this.func_70107_b(d0, y, d1);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, this.field_70177_z, this.field_70125_A);
        }
    }

    public PlayerEntity getPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    public void upgradeChanged() {
        this.field_70180_af.func_187227_b(UPGRADES_NBT, (Object)this.getUpgradesNBT());
    }

    public void func_110206_u(int jumpPowerIn) {
    }

    public boolean func_184776_b() {
        return this.upgrades.containsKey(SimplePlanesUpgrades.BOOSTER.getId());
    }

    public void func_184775_b(int perc) {
        int cost = 10;
        int fuel = this.getFuel();
        if (fuel > cost) {
            this.field_70180_af.func_187227_b(FUEL, (Object)(fuel - cost));
            if (perc > 80) {
                RocketUpgrade upgrade = (RocketUpgrade)this.upgrades.get(SimplePlanesUpgrades.BOOSTER.getId());
                upgrade.fuel = 20;
            }
        }
    }

    public void func_184777_r_() {
    }
}

