/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.handler;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;

public class PlaneNetworking {
    public static final int MSG_PLANE_QUAT = 0;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simpleplanes", "plane_rotation"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, Quaternion.class, (msg, buff) -> SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187160_a(buff, msg), arg_0 -> SimplePlanesDataSerializers.QUATERNION_SERIALIZER.func_187159_a(arg_0), PlaneNetworking::handle_q);
    }

    public static void handle_q(Quaternion msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity ServerPlayerEntity2 = ((NetworkEvent.Context)ctx.get()).getSender();
            if (ServerPlayerEntity2 != null && ServerPlayerEntity2.func_184187_bx() instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)ServerPlayerEntity2.func_184187_bx();
                planeEntity.setQ(msg);
                MathUtil.Angels angels = MathUtil.toEulerAngles(msg);
                planeEntity.field_70177_z = (float)angels.yaw;
                planeEntity.field_70125_A = (float)angels.pitch;
                planeEntity.rotationRoll = (float)angels.roll;
                planeEntity.setQ_Client(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

