/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SimplePlanesDataSerializers {
    private static final DeferredRegister<DataSerializerEntry> DATA_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DATA_SERIALIZERS, (String)"simpleplanes");
    public static final IDataSerializer<Quaternion> QUATERNION_SERIALIZER = new IDataSerializer<Quaternion>(){

        public void write(PacketBuffer buf, Quaternion q) {
            buf.writeFloat(q.func_195889_a());
            buf.writeFloat(q.func_195891_b());
            buf.writeFloat(q.func_195893_c());
            buf.writeFloat(q.func_195894_d());
        }

        public Quaternion read(PacketBuffer buf) {
            try {
                return new Quaternion(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("packet buffer does not contain enough data to constract plane's Quaternion", e);
            }
        }

        public Quaternion copyValue(Quaternion q) {
            return new Quaternion(q);
        }
    };
    public static final RegistryObject<DataSerializerEntry> QUAT_SERIALIZER = DATA_SERIALIZERS.register("quaternion", () -> new DataSerializerEntry(QUATERNION_SERIALIZER));

    public static void init() {
        DATA_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

