/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.rocket;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.rocket.RocketModel;

public class RocketUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/rocket.png");
    public static int FUEL_PER_GUNPOWDER = 20;
    public int fuel = 0;

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("fuel", this.fuel);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.fuel = compoundNBT.func_74762_e("fuel");
    }

    public RocketUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.BOOSTER.get(), planeEntity);
    }

    @Override
    public boolean tick() {
        this.push();
        return super.tick();
    }

    @Override
    public boolean onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getPlayer().func_184586_b(event.getHand());
        if (this.fuel <= 0 && itemStack.func_77973_b().equals(Items.field_151016_H)) {
            if (!event.getPlayer().func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            this.fuel = FUEL_PER_GUNPOWDER;
            this.planeEntity.addFuel(FUEL_PER_GUNPOWDER * 2);
        }
        this.push();
        return false;
    }

    private void push() {
        if (this.fuel < 0) {
            return;
        }
        --this.fuel;
        Vector3d m = this.planeEntity.func_213322_ci();
        float pitch = 0.0f;
        PlayerEntity player = this.planeEntity.getPlayer();
        if (player != null) {
            if (player.field_191988_bg > 0.0f) {
                if (player.func_70051_ag()) {
                    pitch += 2.0f;
                }
            } else if (player.field_191988_bg < 0.0f) {
                pitch -= 2.0f;
            }
        }
        this.planeEntity.field_70125_A += pitch;
        Vector3d motion = MathUtil.rotationToVector(this.planeEntity.field_70177_z, this.planeEntity.field_70125_A, 0.05);
        this.planeEntity.func_213317_d(m.func_178787_e(motion));
        if (!this.planeEntity.field_70170_p.func_201670_d()) {
            this.planeEntity.spawnParticle((IParticleData)ParticleTypes.field_197631_x, new Vector3f(-0.6f, 0.0f, -1.3f), 5);
            this.planeEntity.spawnParticle((IParticleData)ParticleTypes.field_197631_x, new Vector3f(0.6f, 0.0f, -1.3f), 5);
        }
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialticks) {
        IVertexBuilder ivertexbuilder = buffer.getBuffer(RocketModel.INSTANCE.func_228282_a_(TEXTURE));
        RocketModel.INSTANCE.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

