/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.config;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.sleeplessdev.smarthud.data.HotbarStyle;
import net.sleeplessdev.smarthud.data.PickupStyle;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="smarthud", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModulesConfig {
    public static ForgeConfigSpec.BooleanValue isEnabled;
    public static ForgeConfigSpec.BooleanValue logMissingEntries;
    public static ForgeConfigSpec.BooleanValue alwaysShow;
    public static HotbarStyle hotbarStyle;
    public static ForgeConfigSpec.BooleanValue enableHotbar;
    public static ForgeConfigSpec.BooleanValue mergeDuplicates;
    public static ForgeConfigSpec.BooleanValue renderOverlays;
    public static ForgeConfigSpec.BooleanValue showStackSize;
    public static ForgeConfigSpec.IntValue slotLimit;
    public static final ModulesConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static ForgeConfigSpec.IntValue displayTime;
    public static PickupStyle itemPickupStyle;
    public static ForgeConfigSpec.BooleanValue itemPickupEnabled;
    public static ForgeConfigSpec.IntValue itemLimit;
    public static ForgeConfigSpec.IntValue xOffset;
    public static ForgeConfigSpec.IntValue priorityMode;

    public ModulesConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        isEnabled = builder.define("isEnabled", true);
        logMissingEntries = builder.define("logMissingEntries", false);
        builder.push("hotbar");
        alwaysShow = builder.define("alwaysShow", false);
        enableHotbar = builder.define("enableHotbar", true);
        mergeDuplicates = builder.define("mergeDuplicates", true);
        renderOverlays = builder.define("renderOverlays", true);
        showStackSize = builder.define("showStacksize", false);
        slotLimit = builder.defineInRange("slotLimit", 3, 1, 9);
        xOffset = builder.defineInRange("xOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
        builder.push("itempickup");
        displayTime = builder.defineInRange("displayTime", 3000, 0, Integer.MAX_VALUE);
        itemPickupEnabled = builder.define("itemPickupIsEnabled", true);
        itemLimit = builder.defineInRange("itemLimit", 10, 0, Integer.MAX_VALUE);
        priorityMode = builder.defineInRange("priorityMode", 0, 0, 1);
        builder.pop(2);
    }

    static {
        hotbarStyle = HotbarStyle.OFFHAND;
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ModulesConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair2.getRight();
        CLIENT = (ModulesConfig)specPair2.getLeft();
        itemPickupStyle = PickupStyle.BOTH;
    }
}

