/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.render;

import com.google.common.collect.EvictingQueue;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Iterator;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.sleeplessdev.smarthud.config.ModulesConfig;
import net.sleeplessdev.smarthud.event.ItemPickupQueue;
import net.sleeplessdev.smarthud.util.CachedItem;
import net.sleeplessdev.smarthud.util.HandHelper;
import net.sleeplessdev.smarthud.util.RenderContext;
import net.sleeplessdev.smarthud.util.RenderEvent;
import net.sleeplessdev.smarthud.util.StringHelper;
import net.sleeplessdev.smarthud.util.interpolation.CubicBezierInterpolator;
import net.sleeplessdev.smarthud.util.interpolation.Interpolator;

public final class ItemPickupRender
implements RenderEvent {
    private static final Interpolator ANIMATION = new CubicBezierInterpolator(0.42, 0.0, 0.58, 1.0);
    private static final float ANIMATION_DURATION = 10.0f;

    @Override
    public boolean canRender() {
        return (Boolean)ModulesConfig.itemPickupEnabled.get();
    }

    @Override
    public RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.TEXT;
    }

    @Override
    public void onRenderTickPre(RenderContext ctx) {
        EvictingQueue<CachedItem> items = ItemPickupQueue.items;
        if (!items.isEmpty()) {
            int x = ModulesConfig.itemPickupStyle.hasIcon ? 17 : 4;
            int y = ctx.screenHeight - ctx.getFontHeight() * items.size() - 2 * items.size();
            Iterator iterator = items.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                CachedItem cachedItem = (CachedItem)iterator.next();
                int y1 = y + ctx.getFontHeight() * i + 2 * i;
                if (this.renderLabel(ctx, x, y1, cachedItem)) {
                    iterator.remove();
                }
                ++i;
            }
        }
    }

    private boolean renderLabel(RenderContext ctx, float renderX, float renderY, CachedItem item) {
        float remaining;
        boolean name = ModulesConfig.itemPickupStyle.hasLabel;
        String key = "label.smarthud.pickup." + (name ? "long" : "short");
        String count = StringHelper.getAbbreviatedValue(item.count);
        String label = I18n.func_135052_a((String)key, (Object[])new Object[]{count, item.getName().func_150254_d()});
        int color = 0xFFFFFF;
        int labelWidth = ctx.getStringWidth(label);
        float labelX = HandHelper.getSideOffset(renderX, labelWidth);
        float iconY = HandHelper.getSideOffset(renderX - 14.0f, 10.72f);
        if (HandHelper.isLeftHanded()) {
            labelX += (float)ctx.screenWidth;
            iconY += (float)ctx.screenHeight;
        }
        if ((remaining = (float)item.getRemainingTicks((Integer)ModulesConfig.displayTime.get())) < 0.0f) {
            float time = Math.abs(remaining) + ctx.partialTicks;
            if (time > 10.0f) {
                return true;
            }
            float end = renderX + (float)labelWidth;
            float interpolation = ANIMATION.interpolate(0.0f, 10.0f, time) * end;
            labelX += HandHelper.isLeftHanded() ? interpolation : -interpolation;
            iconY += HandHelper.isLeftHanded() ? interpolation : -interpolation;
        }
        ctx.drawStringWithShadow(label, labelX, renderY, color);
        if (ModulesConfig.itemPickupStyle.hasIcon) {
            GlStateManager.func_227740_m_();
            RenderHelper.func_227780_a_();
            GlStateManager.func_227626_N_();
            GlStateManager.func_227670_b_((double)iconY, (double)((double)renderY - 1.5), (double)0.0);
            GlStateManager.func_227632_a_((double)0.67, (double)0.67, (double)0.67);
            ctx.renderItem(item.stack, 0, 0, true);
            GlStateManager.func_227627_O_();
            RenderHelper.func_74518_a();
        }
        return false;
    }
}

