/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.sleeplessdev.smarthud.config.ModulesConfig;
import net.sleeplessdev.smarthud.config.WhitelistParser;
import net.sleeplessdev.smarthud.event.ItemPickupQueue;
import net.sleeplessdev.smarthud.util.CachedItem;
import net.sleeplessdev.smarthud.util.StackHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smarthud")
public final class SmartHUD {
    public static final String ID = "smarthud";
    public static final String NAME = "Smarter HUD";
    public static final Logger LOGGER = LogManager.getLogger((String)"Smarter HUD");
    public static File configPath;
    public static List<CachedItem> inventory;
    public static long ticksElapsed;

    public SmartHUD() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPreInit);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModulesConfig.CLIENT_SPEC);
    }

    private void onPreInit(FMLClientSetupEvent event) {
        File dir = FMLPaths.CONFIGDIR.get().toFile();
        configPath = new File(dir, ID);
        if (!configPath.exists() && configPath.mkdirs()) {
            LOGGER.debug("Pre-generated configuration directory");
        }
        WhitelistParser.reload();
        ItemPickupQueue.initialize();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        NonNullList inv = player.field_71071_by.field_70462_a;
        ArrayList<CachedItem> inventoryCache = new ArrayList<CachedItem>();
        String dim = player.field_70170_p.func_234922_V_().func_240901_a_().toString();
        for (int slot = 9; slot < 36; ++slot) {
            ItemStack stack = ((ItemStack)inv.get(slot)).func_77946_l();
            if (stack.func_190926_b() || !StackHelper.isWhitelisted(stack, dim)) continue;
            StackHelper.process(inventoryCache, stack);
        }
        inventory = inventoryCache;
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft client = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && !client.func_147113_T()) {
            ++ticksElapsed;
        }
    }

    static {
        inventory = new ArrayList<CachedItem>();
    }
}

