/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.config;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.sleeplessdev.smarthud.SmartHUD;
import net.sleeplessdev.smarthud.config.ModulesConfig;
import net.sleeplessdev.smarthud.util.CachedItem;

@Mod.EventBusSubscriber(modid="smarthud", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class WhitelistParser {
    private static final List<CachedItem> ITEMS = new ArrayList<CachedItem>();

    public static ImmutableList<CachedItem> entries() {
        return ImmutableList.copyOf(ITEMS);
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfig.ModConfigEvent event) {
        if ("smarthud".equals(event.getConfig().getModId())) {
            WhitelistParser.reload();
        }
    }

    public static void reload() {
        JsonArray entries;
        JsonElement file;
        if (!((Boolean)ModulesConfig.isEnabled.get()).booleanValue()) {
            ITEMS.clear();
            ITEMS.add(new CachedItem(new ItemStack((IItemProvider)Items.field_151113_aN)));
            ITEMS.add(new CachedItem(new ItemStack((IItemProvider)Items.field_151111_aL)));
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<String> missingEntries = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(WhitelistParser.getOrGenerateJson()));){
            file = new JsonParser().parse((Reader)reader);
        }
        catch (IOException e) {
            SmartHUD.LOGGER.warn("Failed to parse whitelist config! Please report this to the mod author.");
            e.printStackTrace();
            return;
        }
        ITEMS.clear();
        try {
            entries = file.getAsJsonArray();
        }
        catch (IllegalStateException e) {
            SmartHUD.LOGGER.warn("Received invalid data from the whitelist, please check your formatting!");
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            JsonObject json = entries.get(i).getAsJsonObject();
            if (json.isJsonNull() || !json.has("item")) {
                SmartHUD.LOGGER.warn("Whitelist entry at index {} is missing required value \"item\"", (Object)i);
                continue;
            }
            ResourceLocation id = new ResourceLocation(json.get("item").getAsString());
            Item item = (Item)Registry.field_212630_s.func_82594_a(id);
            if (item == Items.field_190931_a) {
                if (ModList.get().isLoaded(id.func_110624_b())) {
                    SmartHUD.LOGGER.warn("Unable to find item for whitelist entry at index {} by name <{}>", (Object)i, (Object)id);
                    continue;
                }
                if (missingEntries.contains(id.func_110624_b())) continue;
                missingEntries.add(id.toString());
                continue;
            }
            CachedItem cachedItem = new CachedItem(new ItemStack((IItemProvider)item));
            if (json.has("ignore_nbt")) {
                cachedItem.ignoreNBT = json.get("ignore_nbt").getAsBoolean();
            }
            if (json.has("ignore_dmg")) {
                cachedItem.ignoreDmg = json.get("ignore_dmg").getAsBoolean();
            }
            if (json.has("merge_duplicates")) {
                cachedItem.setMergeDuplicates(json.get("merge_duplicates").getAsBoolean());
            }
            if (json.has("dimensions")) {
                JsonArray array = json.get("dimensions").getAsJsonArray();
                if (array.size() == 1) {
                    String dim = array.get(0).getAsString();
                    if (WhitelistParser.isDimensionPresent(dim, i)) {
                        cachedItem.setDimensionPredicate(d -> d.equals(dim));
                    } else {
                        cachedItem.setDimensionPredicate(d -> false);
                    }
                } else {
                    HashSet<String> dims = new HashSet<String>();
                    for (JsonElement element : array) {
                        String dim = element.getAsString();
                        if (!WhitelistParser.isDimensionPresent(dim, i)) continue;
                        dims.add(dim);
                    }
                    cachedItem.setDimensionPredicate(dims::contains);
                }
            }
            if (ITEMS.contains(cachedItem)) continue;
            ITEMS.add(cachedItem);
        }
        long time = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
        SmartHUD.LOGGER.info("Finished processing whitelist config in {}ms", (Object)time);
        if (!missingEntries.isEmpty() && ((Boolean)ModulesConfig.logMissingEntries.get()).booleanValue()) {
            SmartHUD.LOGGER.warn("Entries were skipped as the following items could not be found:");
            for (String entry : missingEntries) {
                SmartHUD.LOGGER.warn("-> " + entry);
            }
        }
    }

    private static boolean isDimensionPresent(String dim, int index) {
        return true;
    }

    private static File getOrGenerateJson() {
        File defaultWhitelist = new File(SmartHUD.configPath, "defaults.json");
        File userWhitelist = new File(SmartHUD.configPath, "whitelist.json");
        WhitelistParser.writeToFile(defaultWhitelist, true);
        if (!userWhitelist.exists()) {
            WhitelistParser.writeToFile(userWhitelist, false);
        }
        return userWhitelist;
    }

    private static void writeToFile(File file, boolean overwrite) {
        String path = "/assets/smarthud/data/whitelist.json";
        try (InputStream stream = SmartHUD.class.getResourceAsStream(path);){
            if (overwrite) {
                Files.copy(stream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(stream, file.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

