/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.event;

import com.google.common.base.Throwables;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ForwardingQueue;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.sleeplessdev.smarthud.config.ModulesConfig;
import net.sleeplessdev.smarthud.util.CachedItem;

@Mod.EventBusSubscriber(modid="smarthud", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemPickupQueue {
    public static EvictingQueue<CachedItem> items = EvictingQueue.create((int)10);
    private static boolean init = false;

    public static void initialize() {
        if (!init) {
            ItemPickupQueue.initializeParticleQueue();
            init = true;
        }
        ItemPickupQueue.reloadQueue();
    }

    private static EvictingQueue<CachedItem> createNewQueue() {
        return EvictingQueue.create((int)((Integer)ModulesConfig.slotLimit.get()));
    }

    private static void reloadQueue() {
        EvictingQueue<CachedItem> newQueue = ItemPickupQueue.createNewQueue();
        if (newQueue.addAll(items)) {
            items = newQueue;
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfig.ModConfigEvent event) {
        if ("smarthud".equals(event.getConfig().getModId())) {
            ItemPickupQueue.reloadQueue();
        }
    }

    private static void initializeParticleQueue() {
        try {
            Field field = ObfuscationReflectionHelper.findField(ParticleManager.class, (String)"field_187241_h");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle itemGetter = ItemPickupQueue.getParticleItemPickupGetter(lookup, "field_174840_a");
            MethodHandle targetGetter = ItemPickupQueue.getParticleItemPickupGetter(lookup, "field_174843_ax");
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            Queue newQueue = (Queue)field.get(particleManager);
            field.set(particleManager, ItemPickupQueue.createForwardingParticleQueue(newQueue, itemGetter, targetGetter));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle getParticleItemPickupGetter(MethodHandles.Lookup lookup, String fieldName) throws IllegalAccessException {
        return lookup.unreflectGetter(ObfuscationReflectionHelper.findField(ItemPickupParticle.class, (String)fieldName));
    }

    private static Queue<Particle> createForwardingParticleQueue(final Queue<Particle> delegate, final MethodHandle itemGetter, final MethodHandle targetGetter) {
        return new ForwardingQueue<Particle>(){

            protected Queue<Particle> delegate() {
                return delegate;
            }

            public boolean add(@Nullable Particle particle) {
                if (!super.add((Object)particle)) {
                    return false;
                }
                if (particle != null && ItemPickupParticle.class.equals(particle.getClass())) {
                    Entity target;
                    Entity item;
                    try {
                        item = itemGetter.invoke(particle);
                        target = targetGetter.invoke(particle);
                    }
                    catch (Throwable e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                    if (item instanceof ItemEntity && target instanceof ClientPlayerEntity) {
                        ItemPickupQueue.handleItemCollection(((ItemEntity)item).func_92059_d());
                    }
                }
                return true;
            }
        };
    }

    private static void handleItemCollection(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        EvictingQueue<CachedItem> newItems = ItemPickupQueue.createNewQueue();
        newItems.addAll(items);
        if (items.isEmpty()) {
            newItems.add((Object)new CachedItem(stack, stack.func_190916_E()));
        } else {
            boolean shouldCache = true;
            for (CachedItem cachedItem : items) {
                if (!cachedItem.matchesStack(stack, true)) continue;
                int count = cachedItem.count + stack.func_190916_E();
                if ((Integer)ModulesConfig.priorityMode.get() == 0) {
                    newItems.remove((Object)cachedItem);
                    newItems.add((Object)new CachedItem(stack, count));
                    shouldCache = false;
                    break;
                }
                if ((Integer)ModulesConfig.priorityMode.get() != 1) break;
                cachedItem.count = count;
                cachedItem.renewTimestamp();
                shouldCache = false;
                break;
            }
            if (shouldCache) {
                newItems.add((Object)new CachedItem(stack, stack.func_190916_E()));
            }
        }
        items = newItems;
    }
}

