/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.event;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sleeplessdev.smarthud.render.HotbarRender;
import net.sleeplessdev.smarthud.render.ItemPickupRender;
import net.sleeplessdev.smarthud.util.RenderContext;
import net.sleeplessdev.smarthud.util.RenderEvent;

@Mod.EventBusSubscriber(modid="smarthud", value={Dist.CLIENT})
public class RenderManager {
    private static final List<RenderEvent> EVENTS = Lists.newArrayList((Object[])new RenderEvent[]{new HotbarRender(), new ItemPickupRender()});

    @SubscribeEvent
    public static void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        RenderContext ctx = new RenderContext(Minecraft.func_71410_x(), (RenderGameOverlayEvent)event);
        for (RenderEvent renderEvent : EVENTS) {
            if (!RenderManager.canRender(renderEvent, (RenderGameOverlayEvent)event)) continue;
            renderEvent.onRenderTickPre(ctx);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderContext ctx = new RenderContext(mc, (RenderGameOverlayEvent)event);
        for (RenderEvent renderEvent : EVENTS) {
            if (!RenderManager.canRender(renderEvent, (RenderGameOverlayEvent)event)) continue;
            renderEvent.onRenderTickPost(ctx);
        }
    }

    static boolean canRender(RenderEvent renderEvent, RenderGameOverlayEvent event) {
        return renderEvent.canRender() && renderEvent.getType() == event.getType();
    }
}

