/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.util;

import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.sleeplessdev.smarthud.SmartHUD;
import net.sleeplessdev.smarthud.config.ModulesConfig;

public final class CachedItem {
    public final ItemStack stack;
    public final int actualCount;
    public int count;
    private long timestamp;
    public boolean ignoreNBT = true;
    public boolean ignoreDmg = true;
    private Boolean mergeDuplicates = null;
    private Predicate<String> dimensionPredicate;

    public CachedItem(ItemStack stack, int count) {
        this.stack = stack.func_77946_l();
        this.actualCount = stack.func_190916_E();
        this.stack.func_190920_e(1);
        this.count = count;
        this.timestamp = SmartHUD.ticksElapsed;
        this.dimensionPredicate = i -> true;
    }

    public CachedItem(ItemStack stack) {
        this(stack, 1);
    }

    public boolean isMergeDuplicates() {
        return this.mergeDuplicates != null ? this.mergeDuplicates.booleanValue() : ((Boolean)ModulesConfig.mergeDuplicates.get()).booleanValue();
    }

    public void setMergeDuplicates(boolean mergeDuplicates) {
        this.mergeDuplicates = mergeDuplicates;
    }

    public void setDimensionPredicate(Predicate<String> predicate) {
        this.dimensionPredicate = predicate;
    }

    public void renewTimestamp() {
        this.timestamp = SmartHUD.ticksElapsed;
    }

    public ITextComponent getName() {
        return this.stack.func_200301_q();
    }

    public long getRemainingTicks(int cooldown) {
        long time = SmartHUD.ticksElapsed;
        return this.timestamp + (long)(cooldown / 50) - time;
    }

    public boolean matchesDimension(String dimension) {
        return this.dimensionPredicate.test(dimension);
    }

    public boolean matchesStack(ItemStack stack, boolean fuzzy) {
        ItemStack match = stack.func_77946_l();
        match.func_190920_e(1);
        if (!fuzzy) {
            boolean isItemEqual = this.ignoreDmg ? ItemStack.func_185132_d((ItemStack)this.stack, (ItemStack)match) : ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)match);
            boolean isNBTEqual = this.ignoreNBT || ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)match);
            return isItemEqual && isNBTEqual;
        }
        return ItemStack.func_185132_d((ItemStack)this.stack, (ItemStack)match);
    }
}

