/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.sleeplessdev.smarthud.SmartHUD;
import net.sleeplessdev.smarthud.config.ModulesConfig;
import net.sleeplessdev.smarthud.data.HotbarStyle;
import net.sleeplessdev.smarthud.util.CachedItem;
import net.sleeplessdev.smarthud.util.HandHelper;
import net.sleeplessdev.smarthud.util.RenderContext;
import net.sleeplessdev.smarthud.util.RenderEvent;
import net.sleeplessdev.smarthud.util.StringHelper;

public final class HotbarRender
implements RenderEvent {
    private static final ResourceLocation HUD_ELEMENTS = new ResourceLocation("smarthud", "textures/hud/elements.png");

    @Override
    public boolean canRender() {
        return (Boolean)ModulesConfig.enableHotbar.get();
    }

    @Override
    public RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.HOTBAR;
    }

    @Override
    public void onRenderTickPre(RenderContext ctx) {
        List<CachedItem> cachedItems = SmartHUD.inventory;
        int slots = cachedItems.size() >= (Integer)ModulesConfig.slotLimit.get() ? ((Integer)ModulesConfig.slotLimit.get()).intValue() : cachedItems.size();
        int center = ctx.screenWidth / 2;
        int baseOffset = 98;
        int yOffset = ctx.screenHeight + (Integer)ModulesConfig.yOffset.get();
        if (cachedItems.size() > 0) {
            if (ModulesConfig.hotbarStyle != HotbarStyle.INVISIBLE) {
                int width = 20 * cachedItems.size() + 6;
                int xOffset = (int)HandHelper.getSideOffset(baseOffset, width);
                this.renderHotbarBackground(ctx, center + xOffset, yOffset, slots);
            }
            for (int i = 0; i < slots; ++i) {
                CachedItem cachedItem = cachedItems.get(i);
                ItemStack stack = cachedItem.stack;
                int stackOffset = baseOffset + 3 + 20 * i;
                int stackX = center + (int)HandHelper.getSideOffset(stackOffset, 16.0f);
                int stackY = yOffset + 3;
                boolean renderOverlay = !stack.func_77985_e() && (Boolean)ModulesConfig.renderOverlays.get() != false;
                boolean showStackSize = cachedItem.count > 1 && (Boolean)ModulesConfig.showStackSize.get() != false;
                RenderHelper.func_227780_a_();
                ctx.renderItem(stack, stackX, stackY, true);
                if (renderOverlay) {
                    ctx.renderItemOverlays(stack, stackX, stackY);
                }
                RenderHelper.func_74518_a();
                if (!showStackSize) continue;
                int count = cachedItem.isMergeDuplicates() ? cachedItem.count : cachedItem.actualCount;
                int stringWidth = ctx.getStringWidth(Integer.toString(count));
                int labelOffset = baseOffset + (20 - stringWidth) + 20 * i;
                int labelX = (int)((float)center + HandHelper.getSideOffset(labelOffset, stringWidth));
                int labelY = ctx.screenHeight - ctx.getFontHeight() - 1;
                if (labelX < center) {
                    labelX += 18 - stringWidth;
                }
                RenderSystem.disableDepthTest();
                ctx.drawStringWithShadow(ctx.matrices, StringHelper.getAbbreviatedValue(count), labelX, labelY);
            }
        } else if (((Boolean)ModulesConfig.alwaysShow.get()).booleanValue() && ModulesConfig.hotbarStyle != HotbarStyle.INVISIBLE) {
            int offset = (int)HandHelper.getSideOffset(baseOffset, 20.0f);
            this.renderHotbarBackground(ctx, center + offset, ctx.screenHeight - 22, 1);
        }
        if (ctx.getGameSettings().field_186716_M == AttackIndicatorStatus.HOTBAR) {
            ctx.getGameSettings().field_186716_M = AttackIndicatorStatus.OFF;
        }
    }

    @Override
    public void onRenderTickPost(RenderContext ctx) {
        if (ctx.getGameSettings().field_186716_M == AttackIndicatorStatus.OFF) {
            if (ctx.getRenderViewEntity() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)ctx.getRenderViewEntity();
                HandSide side = player.func_184591_cq().func_188468_a();
                double strength = ctx.getPlayer().func_184825_o(0.0f);
                if (strength < 1.0) {
                    int halfWidth = ctx.screenWidth / 2;
                    int y = ctx.screenHeight - 20;
                    int offset = 91 + this.getAttackIndicatorOffset();
                    int x = halfWidth + (side == HandSide.RIGHT ? -offset - 22 : offset + 6);
                    int strPixel = (int)(strength * 19.0);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableRescaleNormal();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderHelper.func_227780_a_();
                    ctx.bindTexture(AbstractGui.field_230665_h_);
                    ctx.drawTexturedModalRect(ctx.matrices, x, y, 0, 94, 18, 18);
                    ctx.drawTexturedModalRect(ctx.matrices, x, y + 18 - strPixel, 18, 112 - strPixel, 18, strPixel);
                    RenderHelper.func_74518_a();
                    RenderSystem.disableRescaleNormal();
                    RenderSystem.disableBlend();
                }
            }
            ctx.getGameSettings().field_186716_M = AttackIndicatorStatus.CROSSHAIR;
        }
    }

    private int getAttackIndicatorOffset() {
        List<CachedItem> cachedItems = SmartHUD.inventory;
        int slot = 20;
        int padding = 9;
        if (cachedItems.size() > 0) {
            int slots = cachedItems.size() < (Integer)ModulesConfig.slotLimit.get() ? cachedItems.size() : ((Integer)ModulesConfig.slotLimit.get()).intValue();
            return slot * slots + padding;
        }
        if (((Boolean)ModulesConfig.alwaysShow.get()).booleanValue()) {
            return slot + padding;
        }
        return 0;
    }

    private void renderHotbarBackground(RenderContext ctx, int x, int y, int slots) {
        int textureY = ModulesConfig.hotbarStyle.textureY;
        ctx.bindTexture(HUD_ELEMENTS);
        ctx.drawTexturedModalRect(ctx.matrices, x, y, 0, textureY, 11, 22);
        for (int i = 0; i < (slots - 1) * 2; ++i) {
            int textureX = i % 2 == 0 ? 32 : 22;
            ctx.drawTexturedModalRect(ctx.matrices, x + (11 + 10 * i), y, textureX, textureY, 10, 22);
        }
        ctx.drawTexturedModalRect(ctx.matrices, x + 20 * slots - 9, y, 11, textureY, 11, 22);
    }
}

