/*
 * Decompiled with CFR 0.152.
 */
package net.sleeplessdev.smarthud.util.interpolation;

import net.minecraft.util.math.vector.Vector2f;
import net.sleeplessdev.smarthud.util.interpolation.Interpolator;

public final class CubicBezierInterpolator
implements Interpolator {
    private final Vector2f start;
    private final Vector2f end;
    private Vector2f a = new Vector2f(0.0f, 0.0f);
    private Vector2f b = new Vector2f(0.0f, 0.0f);
    private Vector2f c = new Vector2f(0.0f, 0.0f);

    public CubicBezierInterpolator(Vector2f start, Vector2f end) throws IllegalArgumentException {
        if (start.field_189982_i < 0.0f || start.field_189982_i > 1.0f) {
            throw new IllegalArgumentException("start X value must be in the range [0, 1]");
        }
        if (end.field_189982_i < 0.0f || end.field_189982_i > 1.0f) {
            throw new IllegalArgumentException("end X value must be in the range [0, 1]");
        }
        this.start = start;
        this.end = end;
    }

    public CubicBezierInterpolator(float startX, float startY, float endX, float endY) {
        this(new Vector2f(startX, startY), new Vector2f(endX, endY));
    }

    public CubicBezierInterpolator(double startX, double startY, double endX, double endY) {
        this((float)startX, (float)startY, (float)endX, (float)endY);
    }

    @Override
    public float interpolate(float time) {
        return this.getBezierCoordinateY(this.getXForTime(time));
    }

    protected float getBezierCoordinateY(float time) {
        this.c = new Vector2f(this.c.field_189982_i, 3.0f * this.start.field_189983_j);
        this.b = new Vector2f(this.b.field_189982_i, 3.0f * (this.end.field_189983_j - this.start.field_189983_j) - this.c.field_189983_j);
        this.a = new Vector2f(this.a.field_189982_i, 1.0f - this.c.field_189983_j - this.b.field_189983_j);
        return time * (this.c.field_189983_j + time * (this.b.field_189983_j + time * this.a.field_189983_j));
    }

    protected float getXForTime(float time) {
        float z;
        float x = time;
        for (int i = 1; i < 14 && !((double)Math.abs(z = this.getBezierCoordinateX(x) - time) < 0.001); ++i) {
            x -= z / this.getSlope(x);
        }
        return x;
    }

    private float getSlope(float t) {
        return this.c.field_189982_i + t * (2.0f * this.b.field_189982_i + 3.0f * this.a.field_189982_i * t);
    }

    private float getBezierCoordinateX(float time) {
        this.c = new Vector2f(3.0f * this.start.field_189982_i, this.c.field_189983_j);
        this.b = new Vector2f(3.0f * (this.end.field_189982_i - this.start.field_189982_i) - this.c.field_189982_i, this.b.field_189983_j);
        this.a = new Vector2f(1.0f - this.c.field_189982_i - this.b.field_189982_i, this.a.field_189983_j);
        return time * (this.c.field_189982_i + time * (this.b.field_189982_i + time * this.a.field_189982_i));
    }
}

