/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail;

import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlockEntities;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModContainers;
import dev.itsmeow.snailmail.init.ModEntities;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.item.NamedBlockItem;
import dev.itsmeow.snailmail.network.SendEnvelopePacket;
import dev.itsmeow.snailmail.network.SetEnvelopeNamePacket;
import dev.itsmeow.snailmail.network.UpdateSnailBoxPacket;
import dev.itsmeow.snailmail.util.BiMultiMap;
import dev.itsmeow.snailmail.util.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="snailmail", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="snailmail")
public class SnailMail {
    public static final String MODID = "snailmail";
    public static ItemGroup ITEM_GROUP = new ItemGroup("snailmail"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.ENVELOPE_CLOSED);
        }
    };
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("snailmail", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    public static int packets = 0;

    public SnailMail() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.initSpec());
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        HANDLER.registerMessage(packets++, SetEnvelopeNamePacket.class, SetEnvelopeNamePacket::encode, SetEnvelopeNamePacket::decode, SetEnvelopeNamePacket.Handler::handle);
        HANDLER.registerMessage(packets++, SendEnvelopePacket.class, SendEnvelopePacket::encode, SendEnvelopePacket::decode, SendEnvelopePacket.Handler::handle);
        HANDLER.registerMessage(packets++, UpdateSnailBoxPacket.class, UpdateSnailBoxPacket::encode, UpdateSnailBoxPacket::decode, UpdateSnailBoxPacket.Handler::handle);
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModBlocks.SNAIL_BOX);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{new NamedBlockItem(ModBlocks.SNAIL_BOX, new Item.Properties().func_200916_a(ITEM_GROUP)), ModItems.ENVELOPE_OPEN, ModItems.ENVELOPE_CLOSED, ModItems.STAMP});
    }

    @SubscribeEvent
    public static void registerBlockEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(ModBlockEntities.SNAIL_BOX);
    }

    @SubscribeEvent
    public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{ModContainers.SNAIL_BOX, ModContainers.ENVELOPE});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.H.ENTITIES.values().forEach(c -> event.getRegistry().register(c.entityType));
    }

    public static void forceArea(ServerWorld world, BlockPos pos, boolean type) {
        world.func_217458_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, type);
        world.func_217458_b(pos.func_177958_n() >> 5, pos.func_177952_p() >> 4, type);
        world.func_217458_b(pos.func_177958_n() >> 3, pos.func_177952_p() >> 4, type);
        world.func_217458_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 5, type);
        world.func_217458_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 3, type);
    }

    public static boolean deliverTo(SnailBoxBlockEntity te, ItemStack envelope, boolean failed) {
        LazyOptional hOpt = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (hOpt.isPresent() && hOpt.orElse(null) instanceof ItemStackHandler) {
            ItemStackHandler handler = (ItemStackHandler)hOpt.orElse(null);
            Optional<ItemStack> iOpt = EnvelopeItem.convert(envelope);
            if (iOpt.isPresent()) {
                int i;
                ItemStack newEnvelope = iOpt.get();
                if (failed) {
                    if (!newEnvelope.func_77942_o()) {
                        newEnvelope.func_77982_d(new CompoundNBT());
                    }
                    newEnvelope.func_77978_p().func_74757_a("delivery_failed", true);
                }
                ItemStack result = newEnvelope;
                for (i = 0; i < 27 && !result.func_190926_b(); ++i) {
                    result = handler.insertItem(i, newEnvelope, true);
                }
                if (result.func_190926_b()) {
                    result = newEnvelope;
                    for (i = 0; i < 27 && !result.func_190926_b(); ++i) {
                        result = handler.insertItem(i, newEnvelope, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static class Configuration {
        public static ForgeConfigSpec SPEC = null;
        protected static Configuration INSTANCE = null;
        public final ForgeConfigSpec.BooleanValue LOCK_BOXES;
        public final ForgeConfigSpec.BooleanValue PROTECT_BOX_DESTROY;

        public static Configuration get() {
            return INSTANCE;
        }

        public static ForgeConfigSpec initSpec() {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Configuration)specPair.getLeft();
            return (ForgeConfigSpec)specPair.getRight();
        }

        protected Configuration(ForgeConfigSpec.Builder builder) {
            this.LOCK_BOXES = builder.comment("Block snailboxes from being opened by non-owners").define("lock_boxes", true);
            this.PROTECT_BOX_DESTROY = builder.comment("Protect snailboxes from being destroyed by non-owners").define("protect_box_destroy", true);
        }
    }

    public static class SnailBoxData
    extends WorldSavedData {
        private final BiMultiMap<UUID, Location> snailBoxes = new BiMultiMap();
        private final BiMultiMap<UUID, Location> members = new BiMultiMap();
        private final Map<Location, String> names = new HashMap<Location, String>();
        private final Map<Location, Boolean> publicM = new HashMap<Location, Boolean>();

        public SnailBoxData() {
            super("SNAIL_BOXES");
        }

        public void updateAll(UUID owner, String name, boolean publicBox, Set<UUID> membersIn, Location pos) {
            this.snailBoxes.put(owner, pos);
            this.names.put(pos, name);
            this.publicM.put(pos, publicBox);
            for (UUID member : membersIn) {
                this.members.put(member, pos);
            }
            this.func_76185_a();
        }

        public void update(UUID owner, String name, boolean forceName, Location pos) {
            if (forceName || !this.names.containsKey(pos)) {
                this.names.put(pos, name);
            }
            this.snailBoxes.putIfAbsent(owner, pos);
            this.func_76185_a();
        }

        public void moveBox(Location oldLoc, Location newLoc) {
            UUID owner = this.getOwner(oldLoc);
            String name = this.names.remove(oldLoc);
            boolean publicB = this.isPublic(oldLoc);
            Set<UUID> memberL = this.members.getKeys(oldLoc);
            this.removeBoxRaw(oldLoc);
            this.updateAll(owner, name, publicB, memberL, newLoc);
        }

        public void removeBoxRaw(Location pos) {
            this.snailBoxes.removeValueFromAll(pos);
            this.names.remove(pos);
            this.members.removeValueFromAll(pos);
            this.publicM.remove(pos);
            this.func_76185_a();
        }

        public Set<Location> getBoxes(UUID owner) {
            return this.snailBoxes.getValues(owner);
        }

        public Set<Location> getMemberBoxes(UUID member) {
            return this.members.getValues(member);
        }

        public Set<Location> getAllBoxes() {
            return this.snailBoxes.getValuesToKeys().keySet();
        }

        public String getNameForPos(Location pos) {
            return this.names.get(pos);
        }

        public void setNameForPos(Location pos, String name) {
            this.names.put(pos, name);
            this.func_76185_a();
        }

        public boolean isPublic(Location pos) {
            return this.publicM.containsKey(pos) && this.publicM.get(pos) != false;
        }

        public boolean setPublic(Location pos, boolean value) {
            Boolean val = this.publicM.put(pos, value);
            this.func_76185_a();
            return val != null && val != false;
        }

        public boolean isMemberOf(Location pos, UUID uuid) {
            return this.members.getValuesToKeys().containsEntry((Object)pos, (Object)uuid);
        }

        public UUID getOwner(Location location) {
            UUID[] uuid = (UUID[])this.snailBoxes.getValuesToKeys().get((Object)location).toArray((Object[])new UUID[0]);
            return uuid.length == 1 ? uuid[0] : null;
        }

        public void addMember(UUID uuid, Location location) {
            this.members.put(uuid, location);
            this.func_76185_a();
        }

        public void removeMember(UUID uuid, Location location) {
            this.members.remove(uuid, location);
            this.func_76185_a();
        }

        public Set<UUID> getMembers(Location location) {
            return this.members.getKeys(location);
        }

        public void func_76184_a(CompoundNBT nbt) {
            for (String key : nbt.func_150296_c()) {
                UUID uuid = UUID.fromString(key);
                if (uuid == null || !nbt.func_150297_b(key, 9)) continue;
                ListNBT list = nbt.func_150295_c(key, 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT comp = list.func_150305_b(i);
                    Location pos = Location.read(comp);
                    this.snailBoxes.put(uuid, pos);
                    this.names.put(pos, comp.func_74779_i("name"));
                    this.publicM.put(pos, comp.func_74767_n("public"));
                    ListNBT mList = comp.func_150295_c("members", 8);
                    for (int j = 0; j < mList.size(); ++j) {
                        this.members.put(UUID.fromString(mList.func_150307_f(j)), pos);
                    }
                }
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            this.snailBoxes.getKeysToValues().keySet().forEach(key -> {
                ListNBT list = new ListNBT();
                this.snailBoxes.getValues((UUID)key).forEach(pos -> {
                    CompoundNBT comp = new CompoundNBT();
                    pos.write(comp);
                    comp.func_74778_a("name", this.names.get(pos));
                    comp.func_74757_a("public", this.publicM.get(pos).booleanValue());
                    ListNBT list2 = new ListNBT();
                    for (UUID member : this.getMembers((Location)pos)) {
                        list2.add((Object)StringNBT.func_229705_a_((String)member.toString()));
                    }
                    comp.func_218657_a("members", (INBT)list2);
                    list.add((Object)comp);
                });
                compound.func_218657_a(key.toString(), (INBT)list);
            });
            return compound;
        }

        public static SnailBoxData getData(MinecraftServer server) {
            ServerWorld world = server.func_71218_a(DimensionType.field_223227_a_);
            DimensionSavedDataManager data = world.func_217481_x();
            SnailBoxData a = (SnailBoxData)data.func_215752_a(SnailBoxData::new, "SNAIL_BOXES");
            return a;
        }
    }
}

