/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.block;

import com.mojang.authlib.GameProfile;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlockEntities;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.util.Location;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snailmail")
public class SnailBoxBlock
extends Block
implements IWaterLoggable {
    private static VoxelShape SHAPE_X;
    private static VoxelShape SHAPE_Z;

    public SnailBoxBlock(String name) {
        super(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 1200.0f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName("snailmail", name);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == Direction.Axis.Z ? SHAPE_X : SHAPE_Z;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_220081_d(BlockState p_220081_1_, IBlockReader p_220081_2_, BlockPos p_220081_3_) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ModBlockEntities.SNAIL_BOX.func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity teB;
        if (state.func_177230_c() != newState.func_177230_c() && (teB = worldIn.func_175625_s(pos)) instanceof SnailBoxBlockEntity) {
            SnailBoxBlockEntity te = (SnailBoxBlockEntity)teB;
            for (int i = 0; i < te.getItemHandler().getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.getItemHandler().getStackInSlot(i));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn == Hand.MAIN_HAND && !worldIn.func_201670_d() && worldIn.func_175625_s(pos) != null) {
            if (SnailBoxBlock.canOpen(worldIn, pos, player)) {
                ((SnailBoxBlockEntity)worldIn.func_175625_s(pos)).openGUI((ServerPlayerEntity)player);
                return ActionResultType.SUCCESS;
            }
            player.func_145747_a(new TranslationTextComponent("message.snailmail.noperm", new Object[0]).func_211708_a(TextFormatting.RED));
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public static boolean canOpen(World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntity teB = worldIn.func_175625_s(pos);
        return teB != null && teB instanceof SnailBoxBlockEntity && SnailBoxBlock.isAccessibleFor((SnailBoxBlockEntity)teB, PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public static boolean isAccessibleFor(SnailBoxBlockEntity te, UUID uuid) {
        return (Boolean)SnailMail.Configuration.get().LOCK_BOXES.get() == false || uuid.equals(te.getOwner()) || te.isMember(uuid);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity && !worldIn.func_201670_d()) {
            UUID uuid = PlayerEntity.func_146094_a((GameProfile)((PlayerEntity)placer).func_146103_bH());
            TileEntity teB = worldIn.func_175625_s(pos);
            if (teB != null && teB instanceof SnailBoxBlockEntity) {
                Set<Location> box = SnailMail.SnailBoxData.getData(worldIn.func_73046_m()).getBoxes(uuid);
                int size = box == null ? 0 : box.size();
                ((SnailBoxBlockEntity)teB).initializeOwner(uuid, ((PlayerEntity)placer).func_146103_bH().getName() + " Snailbox #" + (size + 1), false);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() == ModBlocks.SNAIL_BOX) {
            IWorld world = event.getWorld();
            BlockPos pos = event.getPos();
            UUID uuid = PlayerEntity.func_146094_a((GameProfile)event.getPlayer().func_146103_bH());
            TileEntity teB = world.func_175625_s(pos);
            if (teB != null && teB instanceof SnailBoxBlockEntity) {
                UUID owner = ((SnailBoxBlockEntity)teB).getOwner();
                if (owner != null && !uuid.equals(owner) && ((Boolean)SnailMail.Configuration.get().PROTECT_BOX_DESTROY.get()).booleanValue()) {
                    event.setCanceled(true);
                } else {
                    SnailMail.SnailBoxData.getData(((World)event.getWorld()).func_73046_m()).removeBoxRaw(new Location(event.getWorld(), pos));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        ArrayList list = new ArrayList();
        event.getExplosion().func_180343_e().forEach(pos -> {
            if (event.getWorld().func_180495_p(pos).func_177230_c() == ModBlocks.SNAIL_BOX) {
                list.add(pos);
            }
        });
        for (BlockPos pos2 : list) {
            event.getExplosion().func_180343_e().remove(pos2);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld() instanceof World && !event.getWorld().func_201670_d()) {
            ChunkPos cPos = event.getChunk().func_76632_l();
            Location[] posL = SnailMail.SnailBoxData.getData(((World)event.getWorld()).func_73046_m()).getAllBoxes().toArray(new Location[0]);
            for (int i = 0; i < posL.length; ++i) {
                BlockState state;
                Location loc = posL[i];
                if (loc.getDimension() != event.getWorld().func_201675_m().func_186058_p() || cPos.func_180334_c() > loc.getX() || cPos.func_180332_e() < loc.getX() || cPos.func_180333_d() > loc.getZ() || cPos.func_180330_f() < loc.getZ() || (state = event.getChunk().func_180495_p(loc.toBP())).func_177230_c() == ModBlocks.SNAIL_BOX) continue;
                SnailMail.SnailBoxData.getData(((World)event.getWorld()).func_73046_m()).removeBoxRaw(loc);
            }
        }
    }

    static {
        double d = 0.25;
        SHAPE_X = VoxelShapes.func_197873_a((double)d, (double)0.0, (double)0.0, (double)(1.0 - d), (double)1.0, (double)1.0);
        SHAPE_Z = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)d, (double)1.0, (double)1.0, (double)(1.0 - d));
    }
}

