/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.itsmeow.snailmail.client.screen.SnailBoxSelectionScreen;
import dev.itsmeow.snailmail.util.BoxData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class SnailBoxListWidget
extends ExtendedList<BoxEntry> {
    public static final ResourceLocation MODAL_BIG_TEXTURE = new ResourceLocation("snailmail:textures/gui/modal_big.png");
    private final int listWidth;
    private SnailBoxSelectionScreen parent;

    public SnailBoxListWidget(SnailBoxSelectionScreen parent) {
        Minecraft minecraft = parent.getMinecraft();
        int n = parent.height;
        int n2 = parent.height - 30;
        parent.getFontRenderer().getClass();
        super(minecraft, 256, n, 0, n2, 9 * 2 + 8);
        this.x0 = (parent.width - 256) / 2;
        this.x1 = this.x0 + 256;
        this.parent = parent;
        this.listWidth = 256;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.x0 + this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        for (BoxData box : this.parent.boxes) {
            this.addEntry((AbstractList.AbstractListEntry)new BoxEntry(box));
        }
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        int i = this.getScrollbarPosition();
        int j = i + 6;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int k = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        this.renderList(k, l, p_render_1_, p_render_2_, p_render_3_);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        int j1 = Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        AbstractGui.fill((int)(this.x0 - 6), (int)(this.parent.height - 30), (int)(this.x0 + 256 + 6), (int)this.parent.height, (int)-10461088);
        AbstractGui.fill((int)(this.x0 - 6), (int)(this.parent.height - 30), (int)(this.x0 + 256 + 6), (int)(this.parent.height - 29), (int)-16777216);
    }

    protected void renderBackground() {
        this.parent.renderBackground();
        AbstractGui.fill((int)(this.x0 - 6), (int)0, (int)(this.x0 + 256 + 6), (int)this.parent.height, (int)-12566464);
        AbstractGui.fill((int)(this.x0 - 7), (int)0, (int)(this.x0 - 6), (int)this.parent.height, (int)-16777216);
        AbstractGui.fill((int)(this.x0 + 256 + 6), (int)0, (int)(this.x0 + 256 + 7), (int)this.parent.height, (int)-16777216);
    }

    public class BoxEntry
    extends ExtendedList.AbstractListEntry<BoxEntry> {
        private final BoxData box;

        BoxEntry(BoxData box) {
            this.box = box;
        }

        public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            AbstractGui.fill((int)left, (int)top, (int)(left + entryWidth - 4), (int)(top + entryHeight), (int)-13619152);
            FontRenderer font = SnailBoxListWidget.this.parent.getFontRenderer();
            font.func_211126_b(font.func_78269_a(this.box.name, 256), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            String locString = "";
            if (this.box.pos != null) {
                String posString = "X" + this.box.pos.getX() + " Y" + this.box.pos.getY() + " Z" + this.box.pos.getZ();
                locString = I18n.func_135052_a((String)"modal.snailmail.located", (Object[])new Object[]{posString, this.box.pos.getDimension().getRegistryName().toString().replaceFirst("minecraft:", "")});
            } else {
                locString = I18n.func_135052_a((String)"modal.snailmail.no_location", (Object[])new Object[0]);
            }
            String string = font.func_78269_a(locString, 256);
            float f = left + 3;
            font.getClass();
            font.func_211126_b(string, f, (float)(top + 2 + 9), 0xCCCCCC);
            String s = this.box.member ? I18n.func_135052_a((String)"modal.snailmail.member", (Object[])new Object[0]) : I18n.func_135052_a((String)"modal.snailmail.owner", (Object[])new Object[0]);
            font.func_211126_b(s, (float)(left + 250 - font.func_78256_a(s)), (float)(top + 2), 0x55FF55);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            SnailBoxListWidget.this.setSelected((AbstractList.AbstractListEntry)this);
            return false;
        }

        public BoxData getBox() {
            return this.box;
        }
    }
}

