/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.client.screen;

import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.IEnvelopePacketReceiver;
import dev.itsmeow.snailmail.client.screen.SnailBoxScreen;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.network.SendEnvelopePacket;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SnailBoxModalScreen
extends Screen
implements IEnvelopePacketReceiver {
    private static final ITextComponent TITLE = new TranslationTextComponent("container.snailmail.snail_box", new Object[0]);
    public static final ResourceLocation MODAL_TEXTURE = new ResourceLocation("snailmail:textures/gui/modal.png");
    private SendEnvelopePacket.Type type;
    private SnailBoxScreen parent;

    public SnailBoxModalScreen(SnailBoxScreen parent, SendEnvelopePacket.Type type) {
        super(TITLE);
        this.parent = parent;
        this.type = type;
    }

    protected void init() {
        super.init();
        this.addButton((Widget)new Button((this.width - 200) / 2, this.height / 2 + 15, 200, 20, I18n.func_135052_a((String)"modal.snailmail.close", (Object[])new Object[0]), btn -> this.minecraft.func_147108_a((Screen)this.parent)));
    }

    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        int modalXSize = 256;
        int modalYSize = 88;
        int modalXStart = (this.width - modalXSize) / 2;
        int modalYStart = (this.height - modalYSize) / 2;
        this.minecraft.func_110434_K().func_110577_a(MODAL_TEXTURE);
        this.blit(modalXStart, modalYStart, 0, 0, modalXSize, modalYSize);
        if (this.type != SendEnvelopePacket.Type.TO_SERVER && this.type != SendEnvelopePacket.Type.WAIT) {
            ItemStack stack;
            String arg = "";
            if (!(this.type != SendEnvelopePacket.Type.INVALID_ADDRESS && this.type != SendEnvelopePacket.Type.NO_BOXES || (stack = ((SnailBoxBlockEntity.SnailBoxContainer)this.parent.func_212873_a_()).func_75139_a(27).func_75211_c()).func_190926_b() || stack.func_77973_b() != ModItems.ENVELOPE_OPEN)) {
                arg = EnvelopeItem.getString(stack, "AddressedTo");
            }
            String[] text = this.font.func_78280_d(I18n.func_135052_a((String)("modal.snailmail." + this.type.name().toLowerCase()), (Object[])new Object[]{arg}), 240).split("\n");
            for (int i = 0; i < text.length; ++i) {
                String string = text[i];
                int n = modalXStart + modalXSize / 2;
                int n2 = modalYStart + modalYSize / 2;
                this.font.getClass();
                this.drawCenteredString(this.font, string, n, n2 - 9 * (text.length - i), 0xFFFFFF);
            }
            super.render(x, y, partialTicks);
        } else {
            int dotAmount = (int)(System.currentTimeMillis() / 333L % 4L);
            String dots = "";
            for (int i = 0; i < dotAmount; ++i) {
                dots = dots + ".";
            }
            this.drawCenteredString(this.font, I18n.func_135052_a((String)"modal.snailmail.sending", (Object[])new Object[0]) + dots, modalXStart + modalXSize / 2, modalYStart + modalYSize / 2, 0xFFFFFF);
        }
    }

    public void onClose() {
        this.minecraft.func_147108_a((Screen)this.parent);
    }

    @Override
    public void receivePacket(SendEnvelopePacket packet) {
        if (packet.type != SendEnvelopePacket.Type.SELECT_BOX) {
            this.type = packet.type;
        } else {
            this.minecraft.func_147108_a((Screen)this.parent);
            this.parent.receivePacket(packet);
        }
    }
}

