/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.IEnvelopePacketReceiver;
import dev.itsmeow.snailmail.client.screen.SnailBoxMemberScreen;
import dev.itsmeow.snailmail.client.screen.SnailBoxModalScreen;
import dev.itsmeow.snailmail.client.screen.SnailBoxSelectionScreen;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.network.SendEnvelopePacket;
import dev.itsmeow.snailmail.network.UpdateSnailBoxPacket;
import dev.itsmeow.snailmail.util.BoxData;
import dev.itsmeow.snailmail.util.RandomUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class SnailBoxScreen
extends ContainerScreen<SnailBoxBlockEntity.SnailBoxContainer>
implements IEnvelopePacketReceiver {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("snailmail:textures/gui/snail_box.png");
    public static final ResourceLocation CHECK_TEXTURE = new ResourceLocation("snailmail:textures/gui/checkbox.png");
    private TextFieldWidget nameField;

    public SnailBoxScreen(SnailBoxBlockEntity.SnailBoxContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 176;
        this.field_147000_g = 199;
    }

    protected void init() {
        super.init();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.addButton((Widget)new Button(xStart + 84, yStart + 4, 67, 20, I18n.func_135052_a((String)"container.snailmail.snail_box.send", (Object[])new Object[0]), bt -> {
            ItemStack envelope = ((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).func_75139_a(27).func_75211_c();
            if (!envelope.func_190926_b() && envelope.func_77973_b() == ModItems.ENVELOPE_OPEN) {
                SendEnvelopePacket packet = new SendEnvelopePacket(SendEnvelopePacket.Type.TO_SERVER);
                this.receivePacket(packet);
                SnailMail.HANDLER.sendToServer((Object)packet);
            }
        }));
        if (((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).isOwner) {
            this.addButton((Widget)new Button(xStart + 88, yStart + 95, 82, 20, I18n.func_135052_a((String)"container.snailmail.snail_box.members", (Object[])new Object[0]), bt -> this.minecraft.func_147108_a((Screen)new SnailBoxMemberScreen(this))));
            CheckboxButton button = new CheckboxButton(xStart + 7, yStart + 82, 79, 14, I18n.func_135052_a((String)"container.snailmail.snail_box.public", (Object[])new Object[0]), ((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).isPublic){

                public void onPress() {
                    super.onPress();
                    SnailMail.HANDLER.sendToServer((Object)new UpdateSnailBoxPacket(this.func_212942_a()));
                    ((SnailBoxBlockEntity.SnailBoxContainer)((SnailBoxScreen)SnailBoxScreen.this).field_147002_h).isPublic = this.func_212942_a();
                }

                public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    minecraft.func_110434_K().func_110577_a(CHECK_TEXTURE);
                    1.blit((int)this.x, (int)this.y, (float)(this.func_212942_a() ? 14.0f : 0.0f), (float)0.0f, (int)14, (int)14, (int)28, (int)14);
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)0.8f, (float)0.8f, (float)1.0f);
                    minecraft.field_71466_p.func_211126_b(this.getMessage(), (float)(this.x + 14 + 4) * 1.25f, (float)(this.y + 4) * 1.25f, -12566464);
                    RenderSystem.popMatrix();
                }
            };
            this.addButton((Widget)button);
        }
        this.minecraft.field_195559_v.func_197967_a(true);
        this.nameField = new TextFieldWidget(this.font, xStart + 88, yStart + 83, 82, 10, I18n.func_135052_a((String)"container.snailmail.snail_box.textfield.name", (Object[])new Object[0])){

            public boolean charTyped(char c, int p_charTyped_2_) {
                if (!this.func_212955_f()) {
                    return false;
                }
                if (RandomUtil.isAllowedCharacter(c, true)) {
                    this.func_146191_b(Character.toString(c));
                    return true;
                }
                return false;
            }
        };
        this.nameField.func_146180_a(((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).startingName);
        this.nameField.func_146205_d(true);
        this.nameField.func_146193_g(0xFFFFFF);
        this.nameField.func_146204_h(0xFFFFFF);
        this.nameField.func_146185_a(true);
        this.nameField.func_146203_f(35);
        this.nameField.func_212954_a(newText -> {
            SnailMail.HANDLER.sendToServer((Object)new UpdateSnailBoxPacket((String)newText));
            ((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).startingName = newText;
        });
        this.nameField.func_146189_e(((SnailBoxBlockEntity.SnailBoxContainer)this.field_147002_h).isOwner);
        this.children.add(this.nameField);
    }

    public void resize(Minecraft mc, int x, int y) {
        String s = this.nameField.func_146179_b();
        this.init(mc, x, y);
        this.nameField.func_146180_a(s);
    }

    public void tick() {
        this.nameField.func_146178_a();
    }

    public void removed() {
        super.removed();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean keyPressed(int key, int a, int b) {
        if (key == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        if (this.nameField.isFocused()) {
            if (!this.nameField.keyPressed(key, a, b) && !this.nameField.func_212955_f()) {
                return super.keyPressed(key, a, b);
            }
            return true;
        }
        return super.keyPressed(key, a, b);
    }

    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        super.render(x, y, partialTicks);
        this.nameField.render(x, y, partialTicks);
        this.func_191948_b(x, y);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 11.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, 104.0f, 0x404040);
    }

    @Override
    public void receivePacket(SendEnvelopePacket msg) {
        if (msg.type == SendEnvelopePacket.Type.SELECT_BOX) {
            this.minecraft.func_147108_a((Screen)new SnailBoxSelectionScreen(this, msg.boxes));
        } else {
            this.minecraft.func_147108_a((Screen)new SnailBoxModalScreen(this, msg.type));
        }
    }

    public void finishSelection(BoxData box) {
        SendEnvelopePacket packet = new SendEnvelopePacket(SendEnvelopePacket.Type.TO_SERVER, box);
        this.receivePacket(packet);
        SnailMail.HANDLER.sendToServer((Object)packet);
    }
}

