/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.entity;

import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModEntities;
import dev.itsmeow.snailmail.util.Location;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class SnailManEntity
extends CreatureEntity {
    private static final DataParameter<Float> OPACITY = EntityDataManager.func_187226_a(SnailManEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> YAW = EntityDataManager.func_187226_a(SnailManEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private Location fromMailbox;
    private Location mailbox;
    private ItemStack transport;
    private boolean leavingDeliveryPoint = true;
    private boolean deliveryFailed = false;

    public SnailManEntity(World worldIn) {
        super(ModEntities.SNAIL_MAN.entityType, worldIn);
        this.func_184224_h(true);
        this.field_70145_X = true;
    }

    public SnailManEntity(World worldIn, Location destination, ItemStack transport, Location fromMailbox) {
        super(ModEntities.SNAIL_MAN.entityType, worldIn);
        this.func_184224_h(true);
        this.func_189654_d(true);
        this.field_70145_X = true;
        this.fromMailbox = fromMailbox;
        this.mailbox = destination;
        this.transport = transport;
    }

    public void setOpacity(float opacity) {
        if (opacity > 1.0f) {
            opacity = 1.0f;
        } else if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        this.field_70180_af.func_187227_b(OPACITY, (Object)Float.valueOf(opacity));
    }

    public float getOpacity() {
        return ((Float)this.field_70180_af.func_187225_a(OPACITY)).floatValue();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OPACITY, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(YAW, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveAwayFromSpawnGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveToBoxGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ReturnFailedDelivery(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70177_z = ((Float)this.field_70180_af.func_187225_a(YAW)).floatValue();
        this.field_70759_as = ((Float)this.field_70180_af.func_187225_a(YAW)).floatValue();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213392_I() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.fromMailbox = Location.read(compound.func_74775_l("fromLocation"));
        this.mailbox = Location.read(compound.func_74775_l("targetLocation"));
        this.transport = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item"));
        this.leavingDeliveryPoint = compound.func_74767_n("leaving");
        this.deliveryFailed = compound.func_74767_n("failed");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT tag1 = new CompoundNBT();
        this.mailbox.write(tag1);
        compound.func_218657_a("targetLocation", (INBT)tag1);
        CompoundNBT tag2 = new CompoundNBT();
        this.fromMailbox.write(tag2);
        compound.func_218657_a("fromLocation", (INBT)tag2);
        CompoundNBT tag = new CompoundNBT();
        this.transport.func_77955_b(tag);
        compound.func_218657_a("item", (INBT)tag);
        compound.func_74757_a("leaving", this.leavingDeliveryPoint);
        compound.func_74757_a("failed", this.deliveryFailed);
    }

    public static class ReturnFailedDelivery
    extends Goal {
        protected SnailManEntity snail;
        private Vec3d to;
        private int totalTicks = 0;
        private float angle = 0.0f;
        private boolean taskReset = false;

        public ReturnFailedDelivery(SnailManEntity snail) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean func_75250_a() {
            return this.snail.fromMailbox != null && this.snail.deliveryFailed;
        }

        public boolean func_75253_b() {
            return !this.taskReset && this.snail.func_174791_d().func_72438_d(this.to) > 1.0 || this.snail.field_70170_p.func_201675_m().func_186058_p() != this.snail.fromMailbox.getDimension();
        }

        public void func_75251_c() {
            boolean isInvalid;
            this.totalTicks = 0;
            this.snail.func_213293_j(0.0, 0.0, 0.0);
            BlockPos pos = this.snail.fromMailbox.toBP();
            TileEntity teB = this.snail.field_70170_p.func_175625_s(pos);
            boolean bl = isInvalid = this.snail.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.SNAIL_BOX || teB == null || !(teB instanceof SnailBoxBlockEntity);
            if (isInvalid || !SnailMail.deliverTo((SnailBoxBlockEntity)teB, this.snail.transport, true)) {
                if (isInvalid) {
                    SnailMail.SnailBoxData.getData(this.snail.func_184102_h()).removeBoxRaw(this.snail.fromMailbox);
                }
                this.snail.func_199701_a_(this.snail.transport);
            }
            SnailMail.forceArea(this.snail.fromMailbox.getWorld(this.snail.func_184102_h()), pos, false);
            this.snail.func_70106_y();
        }

        public void func_75249_e() {
            BlockPos newPos;
            this.to = this.snail.fromMailbox.asVec();
            this.angle = this.getDirection().func_176734_d().func_185119_l();
            BlockPos away = this.getAwayPos(this.getDirection());
            ServerWorld destWorld = this.snail.fromMailbox.getWorld(this.snail.func_184102_h());
            BlockPos blockPos = newPos = destWorld.func_195588_v(away) ? away : this.snail.fromMailbox.toBP();
            if (destWorld.func_217354_b(newPos.func_177958_n() >> 4, newPos.func_177952_p() >> 4) && destWorld.func_72863_F().func_222865_a(new ChunkPos(newPos.func_177958_n() >> 4, newPos.func_177952_p() >> 4))) {
                if (this.snail.field_70170_p.func_201675_m().func_186058_p() != this.snail.fromMailbox.getDimension()) {
                    this.snail.changeDimension(this.snail.fromMailbox.getDimension(), new ITeleporter(){

                        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                            Entity newEntity = entity.func_200600_R().func_200721_a((World)destWorld);
                            if (newEntity != null) {
                                newEntity.func_180432_n(entity);
                                newEntity.func_174828_a(newPos, angle, newEntity.field_70125_A);
                                newEntity.func_213293_j(0.0, 0.0, 0.0);
                                destWorld.func_217460_e(newEntity);
                            }
                            return entity;
                        }
                    });
                } else {
                    this.snail.func_213293_j(0.0, 0.0, 0.0);
                    this.snail.func_174828_a(newPos, this.angle, this.snail.field_70125_A);
                }
            } else {
                this.taskReset = true;
            }
        }

        public void func_75246_d() {
            if (this.totalTicks > 160) {
                this.snail.func_174828_a(this.snail.fromMailbox.toBP().func_177984_a(), this.angle, this.snail.field_70125_A);
                this.snail.func_213293_j(0.0, 0.0, 0.0);
            } else {
                this.snail.field_70180_af.func_187227_b(YAW, (Object)Float.valueOf(this.angle));
                this.snail.func_213317_d(this.to.func_178788_d(this.snail.func_213303_ch()).func_72432_b().func_186678_a(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.func_213303_ch().func_72438_d(this.to) - 3.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.field_70170_p.func_195588_v(this.snail.fromMailbox.toBP()) && (state = this.snail.field_70170_p.func_180495_p(this.snail.fromMailbox.toBP())) != null && state.func_177230_c() == ModBlocks.SNAIL_BOX) {
                dir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.fromMailbox.toBP().func_177967_a(dir, 7);
        }
    }

    public static class MoveToBoxGoal
    extends Goal {
        protected SnailManEntity snail;
        private Vec3d to;
        private int totalTicks = 0;
        private float angle = 0.0f;
        private boolean taskReset = false;

        public MoveToBoxGoal(SnailManEntity snail) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean func_75250_a() {
            return this.snail.mailbox != null && !this.snail.leavingDeliveryPoint && !this.snail.deliveryFailed;
        }

        public boolean func_75253_b() {
            return !this.taskReset && !this.snail.deliveryFailed && this.snail.func_174791_d().func_72438_d(this.to) > 1.0 || this.snail.field_70170_p.func_201675_m().func_186058_p() != this.snail.mailbox.getDimension();
        }

        public void func_75251_c() {
            boolean isInvalid;
            this.totalTicks = 0;
            this.snail.func_213293_j(0.0, 0.0, 0.0);
            BlockPos pos = this.snail.mailbox.toBP();
            ServerWorld world = this.snail.mailbox.getWorld(this.snail.func_184102_h());
            TileEntity teB = world.func_175625_s(pos);
            boolean bl = isInvalid = world.func_180495_p(pos).func_177230_c() != ModBlocks.SNAIL_BOX || teB == null || !(teB instanceof SnailBoxBlockEntity);
            if (isInvalid || !SnailMail.deliverTo((SnailBoxBlockEntity)teB, this.snail.transport, false)) {
                this.snail.deliveryFailed = true;
                SnailMail.forceArea(this.snail.fromMailbox.getWorld(this.snail.func_184102_h()), this.snail.fromMailbox.toBP(), true);
                if (isInvalid) {
                    SnailMail.SnailBoxData.getData(this.snail.func_184102_h()).removeBoxRaw(this.snail.mailbox);
                }
            } else {
                this.snail.func_70106_y();
            }
            if (this.snail.deliveryFailed || !this.snail.fromMailbox.equals(this.snail.mailbox)) {
                SnailMail.forceArea(world, pos, false);
            }
        }

        public void func_75249_e() {
            BlockPos newPos;
            this.to = this.snail.mailbox.asVec();
            this.angle = this.getDirection().func_176734_d().func_185119_l();
            BlockPos away = this.getAwayPos(this.getDirection());
            ServerWorld destWorld = this.snail.mailbox.getWorld(this.snail.func_184102_h());
            BlockPos blockPos = newPos = destWorld.func_195588_v(away) ? away : this.snail.mailbox.toBP();
            if (destWorld.func_217354_b(newPos.func_177958_n() >> 4, newPos.func_177952_p() >> 4) && destWorld.func_72863_F().func_222865_a(new ChunkPos(newPos.func_177958_n() >> 4, newPos.func_177952_p() >> 4))) {
                this.transport(newPos);
            } else {
                this.taskReset = true;
            }
        }

        public void func_75246_d() {
            if (this.totalTicks > 160) {
                this.snail.func_174828_a(this.snail.mailbox.toBP().func_177984_a(), this.angle, this.snail.field_70125_A);
                this.snail.func_213293_j(0.0, 0.0, 0.0);
            } else {
                this.snail.field_70180_af.func_187227_b(YAW, (Object)Float.valueOf(this.angle));
                this.snail.func_213317_d(this.to.func_178788_d(this.snail.func_213303_ch()).func_72432_b().func_186678_a(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.func_213303_ch().func_72438_d(this.to) - 3.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.field_70170_p.func_195588_v(this.snail.mailbox.toBP()) && (state = this.snail.field_70170_p.func_180495_p(this.snail.mailbox.toBP())) != null && state.func_177230_c() == ModBlocks.SNAIL_BOX) {
                dir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.mailbox.toBP().func_177967_a(dir, 7);
        }

        private void transport(final BlockPos newPos) {
            if (this.snail.field_70170_p.func_201675_m().func_186058_p() != this.snail.mailbox.getDimension()) {
                this.snail.changeDimension(this.snail.mailbox.getDimension(), new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity newEntity = entity.func_200600_R().func_200721_a((World)destWorld);
                        if (newEntity != null) {
                            newEntity.func_180432_n(entity);
                            newEntity.func_174828_a(newPos, angle, newEntity.field_70125_A);
                            newEntity.func_213293_j(0.0, 0.0, 0.0);
                            destWorld.func_217460_e(newEntity);
                        }
                        return entity;
                    }
                });
            } else {
                this.snail.func_213293_j(0.0, 0.0, 0.0);
                this.snail.func_174828_a(newPos, this.angle, this.snail.field_70125_A);
            }
        }
    }

    public static class MoveAwayFromSpawnGoal
    extends Goal {
        protected SnailManEntity snail;
        private Vec3d from;
        private int totalTicks = 0;
        private Vec3d dest;

        public MoveAwayFromSpawnGoal(SnailManEntity snail) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.snail = snail;
        }

        public boolean func_75250_a() {
            return this.snail.fromMailbox != null && this.snail.leavingDeliveryPoint;
        }

        public boolean func_75253_b() {
            return this.snail.func_174791_d().func_72438_d(this.from) < 7.0 && this.snail.leavingDeliveryPoint && this.totalTicks < 160;
        }

        public void func_75251_c() {
            this.totalTicks = 0;
            this.dest = null;
            this.snail.leavingDeliveryPoint = false;
            this.snail.func_213293_j(0.0, 0.0, 0.0);
        }

        public void func_75249_e() {
            this.from = this.snail.fromMailbox.asVec();
        }

        public void func_75246_d() {
            Direction direction = this.getDirection();
            if (this.dest == null) {
                BlockPos away = this.getAwayPos(direction);
                this.dest = new Vec3d((double)away.func_177958_n() + 0.5, (double)away.func_177956_o(), (double)away.func_177952_p() + 0.5);
            }
            if (this.dest != null) {
                this.snail.field_70180_af.func_187227_b(YAW, (Object)Float.valueOf(direction.func_185119_l()));
                this.snail.func_213317_d(this.dest.func_178788_d(this.snail.func_213303_ch()).func_72432_b().func_186678_a(0.05));
                float opacity = Math.abs(6.0f - Math.min((float)this.snail.func_213303_ch().func_72438_d(this.from) - 1.0f, 6.0f)) / 6.0f;
                this.snail.setOpacity(opacity < 0.2f ? 0.0f : opacity);
            }
            ++this.totalTicks;
        }

        private Direction getDirection() {
            BlockState state;
            Direction dir = Direction.NORTH;
            if (this.snail.field_70170_p.func_195588_v(this.snail.fromMailbox.toBP()) && (state = this.snail.field_70170_p.func_180495_p(this.snail.fromMailbox.toBP())) != null && state.func_177230_c() == ModBlocks.SNAIL_BOX) {
                dir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            }
            return dir;
        }

        private BlockPos getAwayPos(Direction dir) {
            return this.snail.fromMailbox.toBP().func_177967_a(dir, 7);
        }
    }
}

