/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import com.mojang.authlib.GameProfile;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.IEnvelopePacketReceiver;
import dev.itsmeow.snailmail.entity.SnailManEntity;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.util.BoxData;
import dev.itsmeow.snailmail.util.Location;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SendEnvelopePacket {
    public Type type;
    public BoxData[] boxes;

    public SendEnvelopePacket(Type type) {
        this.type = type;
    }

    public SendEnvelopePacket(Type type, BoxData ... boxes) {
        this.type = type;
        this.boxes = boxes;
    }

    public static void encode(SendEnvelopePacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.type.ordinal());
        if (pkt.boxes != null) {
            buf.writeInt(pkt.boxes.length);
            for (BoxData box : pkt.boxes) {
                box.write(buf);
            }
        }
    }

    public static SendEnvelopePacket decode(PacketBuffer buf) {
        Type type = Type.values()[buf.readInt()];
        BoxData[] boxL = null;
        if (buf.readableBytes() > 0) {
            int len = buf.readInt();
            boxL = new BoxData[len];
            for (int i = 0; i < len; ++i) {
                boxL[i] = BoxData.read(buf);
            }
        }
        return new SendEnvelopePacket(type, boxL);
    }

    public static boolean deliver(SnailBoxBlockEntity fromTe, ItemStack stack, Location location, Location from, ServerPlayerEntity player) {
        IItemHandler handlerRaw;
        LazyOptional hOpt = fromTe.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (hOpt.isPresent() && (handlerRaw = (IItemHandler)hOpt.orElse(null)) instanceof ItemStackHandler) {
            ItemStackHandler handler = (ItemStackHandler)handlerRaw;
            stack = stack.func_77946_l();
            handler.setStackInSlot(27, ItemStack.field_190927_a);
            ServerWorld fromW = from.getWorld(player.func_184102_h());
            SnailManEntity snail = new SnailManEntity((World)fromW, location, stack, from);
            snail.func_213386_a((IWorld)fromW, fromW.func_175649_E(from.toBP()), SpawnReason.MOB_SUMMONED, null, null);
            BlockPos pos = from.toBP().func_177972_a((Direction)fromTe.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J));
            snail.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            fromW.func_217376_c((Entity)snail);
            return true;
        }
        return false;
    }

    public static class Handler {
        public static void handle(SendEnvelopePacket msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER && msg.type == Type.TO_SERVER) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (sender.field_71070_bA instanceof SnailBoxBlockEntity.SnailBoxContainer) {
                        ItemStack stack = sender.field_71070_bA.func_75139_a(27).func_75211_c();
                        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.ENVELOPE_OPEN) {
                            if (EnvelopeItem.isStamped(stack)) {
                                String to = EnvelopeItem.getString(stack, "AddressedTo");
                                if (!to.isEmpty()) {
                                    Handler.reply(ctx, Type.WAIT);
                                    new Thread(() -> Handler.lambda$null$6(sender, to, (Supplier)ctx, msg, stack)).start();
                                } else {
                                    Handler.reply(ctx, Type.NO_ADDRESS);
                                }
                            } else {
                                Handler.reply(ctx, Type.NO_STAMP);
                            }
                        } else {
                            Handler.reply(ctx, Type.NO_ENVELOPE);
                        }
                    }
                });
            }
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT && msg.type != Type.TO_SERVER) {
                ctx.get().enqueueWork(() -> {
                    if (Minecraft.func_71410_x().field_71462_r instanceof IEnvelopePacketReceiver) {
                        ((IEnvelopePacketReceiver)Minecraft.func_71410_x().field_71462_r).receivePacket(msg);
                    }
                });
            }
            ctx.get().setPacketHandled(true);
        }

        private static void reply(Supplier<NetworkEvent.Context> ctx, Type response) {
            SnailMail.HANDLER.sendTo((Object)new SendEnvelopePacket(response), ctx.get().getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
        }

        private static void reply(Supplier<NetworkEvent.Context> ctx, Type response, BoxData ... boxData) {
            SnailMail.HANDLER.sendTo((Object)new SendEnvelopePacket(response, boxData), ctx.get().getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
        }

        private static /* synthetic */ void lambda$null$6(ServerPlayerEntity sender, String to, Supplier ctx, SendEnvelopePacket msg, ItemStack stack) {
            GameProfile prof = sender.func_184102_h().func_152358_ax().func_152655_a(to);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> Handler.lambda$null$5(prof, sender, msg, (Supplier)ctx, stack));
        }

        private static /* synthetic */ void lambda$null$5(GameProfile prof, ServerPlayerEntity sender, SendEnvelopePacket msg, Supplier ctx, ItemStack stack) {
            if (prof != null && prof.getId() != null) {
                UUID uuid = prof.getId();
                SnailMail.SnailBoxData data = SnailMail.SnailBoxData.getData(sender.func_184102_h());
                Set<Location> boxPos = data.getBoxes(uuid);
                HashSet<BoxData> boxes = new HashSet<BoxData>();
                for (Location location : boxPos) {
                    boxes.add(new BoxData(data.getNameForPos(location), location, data.isPublic(location), false));
                }
                Set<Location> boxPosMember = data.getMemberBoxes(uuid);
                for (Location pos : boxPosMember) {
                    boxes.add(new BoxData(data.getNameForPos(pos), pos, data.isPublic(pos), true));
                }
                if (boxes.size() > 0) {
                    if (msg.boxes == null) {
                        List<BoxData> list = boxes.stream().sorted((element1, element2) -> element1.name.length() > element2.name.length() ? 1 : (element1.name.length() < element2.name.length() ? -1 : element1.name.compareTo(element2.name))).collect(Collectors.toList());
                        Handler.reply(ctx, Type.SELECT_BOX, list.toArray(new BoxData[0]));
                    } else if (msg.boxes.length == 1) {
                        int n = msg.boxes[0].posHash;
                        HashSet<Location> hashes = new HashSet<Location>(boxPos);
                        hashes.removeIf(p -> p.hashCode() != hashWanted);
                        Location selected = null;
                        if (hashes.size() == 1) {
                            selected = hashes.toArray(new Location[1])[0];
                        } else {
                            HashSet<Location> hashesM = new HashSet<Location>(boxPosMember);
                            hashesM.removeIf(p -> p.hashCode() != hashWanted);
                            if (hashesM.size() == 1) {
                                selected = hashesM.toArray(new Location[1])[0];
                            }
                        }
                        if (selected != null) {
                            SnailBoxBlockEntity fromTe = ((SnailBoxBlockEntity.SnailBoxContainer)sender.field_71070_bA).getTile((PlayerEntity)sender);
                            Location selectFinal = selected;
                            ServerWorld world = selectFinal.getWorld(sender.func_184102_h());
                            BlockPos pos = selectFinal.toBP();
                            Handler.reply(ctx, Type.WAIT);
                            new Thread(() -> Handler.lambda$null$4(world, pos, (Supplier)ctx, fromTe, stack, selectFinal, sender)).start();
                        }
                    }
                } else {
                    Handler.reply(ctx, Type.NO_BOXES);
                }
            } else {
                Handler.reply(ctx, Type.INVALID_ADDRESS);
            }
        }

        private static /* synthetic */ void lambda$null$4(ServerWorld world, BlockPos pos, Supplier ctx, SnailBoxBlockEntity fromTe, ItemStack stack, Location selectFinal, ServerPlayerEntity sender) {
            SnailMail.forceArea(world, pos, true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> Handler.lambda$null$3(world, pos, fromTe, stack, selectFinal, sender, (Supplier)ctx));
        }

        private static /* synthetic */ void lambda$null$3(ServerWorld world, BlockPos pos, SnailBoxBlockEntity fromTe, ItemStack stack, Location selectFinal, ServerPlayerEntity sender, Supplier ctx) {
            if (world.func_195588_v(pos)) {
                TileEntity teB = world.func_175625_s(pos);
                if (world.func_180495_p(pos).func_177230_c() == ModBlocks.SNAIL_BOX && teB != null && teB instanceof SnailBoxBlockEntity) {
                    SendEnvelopePacket.deliver(fromTe, stack, selectFinal, fromTe.getLocation(), sender);
                    Handler.reply(ctx, Type.SUCCESS);
                } else {
                    Handler.reply(ctx, Type.BOX_NO_EXIST);
                    SnailMail.SnailBoxData.getData(sender.func_184102_h()).removeBoxRaw(selectFinal);
                }
            }
        }
    }

    public static enum Type {
        TO_SERVER,
        NO_ENVELOPE,
        NO_STAMP,
        NO_ADDRESS,
        INVALID_ADDRESS,
        NO_BOXES,
        SELECT_BOX,
        SUCCESS,
        BOX_NO_EXIST,
        WAIT;

    }
}

