/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.util.RandomUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetEnvelopeNamePacket {
    public final Type type;
    public String name = "";

    public SetEnvelopeNamePacket(Type type, String name) {
        this.name = name;
        this.type = type;
    }

    public static void encode(SetEnvelopeNamePacket pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.type == Type.FROM);
        buf.writeInt(pkt.name.length());
        buf.writeCharSequence((CharSequence)pkt.name, StandardCharsets.UTF_8);
    }

    public static SetEnvelopeNamePacket decode(PacketBuffer buf) {
        return new SetEnvelopeNamePacket(buf.readBoolean() ? Type.FROM : Type.TO, String.valueOf(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8)));
    }

    public static class Handler {
        public static void handle(SetEnvelopeNamePacket msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (sender.field_71070_bA instanceof EnvelopeItem.EnvelopeContainer) {
                        String s;
                        Hand hand = null;
                        if (sender.func_184586_b(Hand.MAIN_HAND).func_77973_b() == ModItems.ENVELOPE_OPEN) {
                            hand = Hand.MAIN_HAND;
                        } else if (sender.func_184586_b(Hand.OFF_HAND).func_77973_b() == ModItems.ENVELOPE_OPEN) {
                            hand = Hand.OFF_HAND;
                        }
                        if (hand != null && (s = RandomUtil.filterAllowedCharacters(msg.name, false)).length() <= 35) {
                            ItemStack stack = sender.func_184586_b(hand);
                            if (msg.type == Type.TO) {
                                EnvelopeItem.setToName((PlayerEntity)sender, hand, stack, s);
                            } else {
                                EnvelopeItem.setFromName((PlayerEntity)sender, hand, stack, s);
                            }
                        }
                    }
                });
            }
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum Type {
        FROM,
        TO;

    }
}

