/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.util;

import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;

public class Location {
    public static final Location ZERO = new Location(DimensionType.field_223227_a_, 0, 0, 0);
    private final DimensionType dimension;
    private final int x;
    private final int y;
    private final int z;

    public Location(IWorld world, BlockPos pos) {
        this(world.func_201675_m().func_186058_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(IWorld world, int x, int y, int z) {
        this(world.func_201675_m().func_186058_p(), x, y, z);
    }

    public Location(DimensionType dimension, BlockPos pos) {
        this(dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(DimensionType dimension, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos toBP() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void write(PacketBuffer buf) {
        buf.func_211400_a(this.dimension.getRegistryName().toString(), 60);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static Location read(PacketBuffer buf) {
        return new Location(DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(buf.func_150789_c(60))), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("dim", this.dimension.getRegistryName().toString());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        return tag;
    }

    public static Location read(CompoundNBT tag) {
        return new Location(DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(tag.func_74779_i("dim"))), tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public ServerWorld getWorld(MinecraftServer server) {
        return DimensionManager.getWorld((MinecraftServer)server, (DimensionType)this.dimension, (boolean)true, (boolean)true);
    }

    public int hashCode() {
        return Objects.hash(this.dimension.getRegistryName().toString(), this.x, this.y, this.z);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location otherL = (Location)other;
        if (this.getX() != otherL.getX()) {
            return false;
        }
        if (this.getY() != otherL.getY()) {
            return false;
        }
        if (this.getZ() != otherL.getZ()) {
            return false;
        }
        return this.getDimension() == otherL.getDimension();
    }

    public Vec3d asVec() {
        return new Vec3d((double)this.x + 0.5, (double)this.y, (double)this.z + 0.5);
    }
}

