/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.block.entity;

import com.mojang.authlib.GameProfile;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.SnailBoxBlock;
import dev.itsmeow.snailmail.init.ModBlockEntities;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModContainers;
import dev.itsmeow.snailmail.util.EnvelopeSlot;
import dev.itsmeow.snailmail.util.Location;
import dev.itsmeow.snailmail.util.ReadOnlySlot;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SnailBoxBlockEntity
extends TileEntity {
    private static final int SLOT_COUNT = 28;
    private ItemStackHandler handler = new ItemStackHandler(28){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SnailBoxBlockEntity.this.func_70296_d();
        }
    };
    public final LazyOptional<ItemStackHandler> handlerOptional = LazyOptional.of(() -> this.handler);
    public static final ITextComponent TITLE = new TranslationTextComponent("container.snailmail.snail_box");
    private static final String ITEM_TAG_KEY = "item_handler";

    public SnailBoxBlockEntity() {
        super(ModBlockEntities.SNAIL_BOX);
    }

    protected SnailMail.SnailBoxData data() {
        return SnailMail.SnailBoxData.getData(this.func_145831_w().func_73046_m());
    }

    public boolean isPublic() {
        return this.data().isPublic(this.getLocation());
    }

    public boolean isMember(UUID uuid) {
        return this.data().isMemberOf(this.getLocation(), uuid);
    }

    public UUID getOwner() {
        return this.data().getOwner(this.getLocation());
    }

    public void initializeOwner(UUID uuid, String name, boolean forceName) {
        this.data().update(uuid, name, forceName, this.getLocation());
        this.data().setPublic(this.getLocation(), false);
    }

    public void addMember(UUID uuid) {
        this.data().addMember(uuid, this.getLocation());
    }

    public void removeMember(UUID uuid) {
        this.data().removeMember(uuid, this.getLocation());
    }

    public void setPublic(boolean publicB) {
        this.data().setPublic(this.getLocation(), publicB);
    }

    public Set<UUID> getMembers() {
        return this.data().getMembers(this.getLocation());
    }

    public ItemStackHandler getItemHandler() {
        return this.handler;
    }

    public void func_145843_s() {
        this.handlerOptional.invalidate();
        super.func_145843_s();
    }

    public void setName(String name) {
        this.data().setNameForPos(this.getLocation(), name);
    }

    public void func_226984_a_(World newWorld, BlockPos newPos) {
        if (this.field_174879_c != null && this.field_145850_b != null && (newWorld != this.field_145850_b || newPos != this.field_174879_c)) {
            this.data().moveBox(this.getLocation(), new Location(newWorld, newPos));
        }
        super.func_226984_a_(newWorld, newPos);
    }

    public void func_174878_a(BlockPos newPos) {
        if (this.field_174879_c != null && this.field_145850_b != null && newPos != this.field_174879_c) {
            this.data().moveBox(this.getLocation(), new Location(this.field_145850_b, newPos));
        }
        super.func_174878_a(newPos);
    }

    public void func_145836_u() {
        if (!this.func_145831_w().field_72995_K && this.field_145850_b.func_195588_v(this.func_174877_v()) && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() != ModBlocks.SNAIL_BOX) {
            SnailMail.SnailBoxData.getData(this.func_145831_w().func_73046_m()).removeBoxRaw(this.getLocation());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.handler.deserializeNBT(nbt.func_74775_l(ITEM_TAG_KEY));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(ITEM_TAG_KEY, (INBT)this.handler.serializeNBT());
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void openGUI(ServerPlayerEntity player) {
        new Thread(() -> {
            IContainerProvider provider = SnailBoxContainer.getServerContainerProvider(this);
            SimpleNamedContainerProvider namedProvider = new SimpleNamedContainerProvider(provider, TITLE);
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)namedProvider, buf -> {
                String name = this.data().getNameForPos(this.getLocation());
                if (name == null) {
                    name = "";
                }
                buf.func_211400_a(name, 35);
                buf.writeBoolean(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(this.getOwner()));
                buf.writeBoolean(this.isPublic());
                HashSet<String> usernames = new HashSet<String>();
                for (UUID member : this.getMembers()) {
                    GameProfile profile = player.func_184102_h().func_152358_ax().func_152652_a(member);
                    if (profile != null && profile.getName() != null && !profile.getName().isEmpty()) {
                        usernames.add(profile.getName());
                        continue;
                    }
                    usernames.add(member.toString());
                }
                buf.writeInt(usernames.size());
                for (String username : usernames) {
                    buf.func_180714_a(username);
                }
            });
        }).start();
    }

    public Location getLocation() {
        return new Location(this.func_145831_w(), this.func_174877_v());
    }

    public static class SnailBoxContainer
    extends Container {
        private final BlockPos pos;
        private final ItemStackHandler items;
        public String startingName;
        public boolean isOwner = false;
        public boolean isPublic = false;
        public Set<String> memberUsers = new HashSet<String>();

        public static SnailBoxContainer getClientContainer(int id, PlayerInventory playerInventory, PacketBuffer extra) {
            if (extra.readableBytes() > 0) {
                String name = extra.func_150789_c(35);
                boolean isOwner = extra.readBoolean();
                boolean isPublic = extra.readBoolean();
                int len = extra.readInt();
                HashSet<String> usernames = new HashSet<String>();
                for (int i = 0; i < len; ++i) {
                    usernames.add(extra.func_150789_c(35));
                }
                return new SnailBoxContainer(id, (IInventory)playerInventory, new ItemStackHandler(28), name, isOwner, isPublic, usernames);
            }
            return new SnailBoxContainer(id, (IInventory)playerInventory, new ItemStackHandler(28), "", false, false, new HashSet<String>());
        }

        public static IContainerProvider getServerContainerProvider(SnailBoxBlockEntity te) {
            return (id, playerInventory, serverPlayer) -> new SnailBoxContainer(id, (IInventory)playerInventory, te.func_174877_v(), te.getItemHandler());
        }

        public SnailBoxContainer(int id, IInventory playerInventory, BlockPos pos, ItemStackHandler items) {
            super(ModContainers.SNAIL_BOX, id);
            this.items = items;
            this.pos = pos;
            this.startingName = "";
            this.addOwnSlots();
            this.addPlayerSlots(playerInventory);
        }

        public SnailBoxContainer(int id, IInventory playerInventory, ItemStackHandler items, String startingName, boolean isOwner, boolean isPublic, Set<String> members) {
            super(ModContainers.SNAIL_BOX, id);
            this.items = items;
            this.pos = BlockPos.field_177992_a;
            this.startingName = startingName;
            this.isOwner = isOwner;
            this.isPublic = isPublic;
            this.memberUsers = members;
            this.addOwnSlots();
            this.addPlayerSlots(playerInventory);
        }

        private void addPlayerSlots(IInventory playerInventory) {
            int row;
            for (row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    int x = 8 + col * 18;
                    int y = row * 18 + 117;
                    this.func_75146_a(new Slot(playerInventory, col + row * 9 + 9, x, y));
                }
            }
            for (row = 0; row < 9; ++row) {
                int x = 8 + row * 18;
                int y = 175;
                this.func_75146_a(new Slot(playerInventory, row, x, y));
            }
        }

        private void addOwnSlots() {
            for (int i = 0; i < 27; ++i) {
                int yCoord = i / 9 * 18;
                int xCoord = i % 9 * 18;
                this.func_75146_a((Slot)new ReadOnlySlot((IItemHandler)this.items, i, 8 + xCoord, 26 + yCoord));
            }
            this.func_75146_a((Slot)new EnvelopeSlot((IItemHandler)this.items, 27, 152, 6));
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (index < 28 ? !this.func_75135_a(itemstack1, 28, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 28, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            }
            return itemstack;
        }

        public boolean func_75145_c(PlayerEntity player) {
            return SnailBoxContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)this.pos), (PlayerEntity)player, (Block)ModBlocks.SNAIL_BOX) && SnailBoxBlock.canOpen(player.field_70170_p, this.pos, player);
        }

        public SnailBoxBlockEntity getTile(PlayerEntity player) {
            TileEntity te = player.field_70170_p.func_175625_s(this.pos);
            if (te != null && this.func_75145_c(player) && player.field_70170_p.func_180495_p(this.pos).func_177230_c() == ModBlocks.SNAIL_BOX && te instanceof SnailBoxBlockEntity) {
                return (SnailBoxBlockEntity)te;
            }
            return null;
        }
    }
}

