/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.item;

import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.init.ModContainers;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.util.NoItemCapSlot;
import dev.itsmeow.snailmail.util.StampSlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EnvelopeItem
extends Item {
    private final boolean isOpen;
    private static final ITextComponent title = new TranslationTextComponent("container.snailmail.envelope");

    public EnvelopeItem(String name, boolean isOpen) {
        super(new Item.Properties().func_200916_a(SnailMail.ITEM_GROUP).func_200917_a(1));
        this.setRegistryName("snailmail", name);
        this.isOpen = isOpen;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemStack stampSlot;
        LazyOptional cap;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("AddressedTo", 8) && !stack.func_77978_p().func_74779_i("AddressedTo").isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.snailmail.to", new Object[]{new StringTextComponent(stack.func_77978_p().func_74779_i("AddressedTo")).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY))}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GREEN).func_240722_b_(Boolean.valueOf(true))));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("AddressedFrom", 8) && !stack.func_77978_p().func_74779_i("AddressedFrom").isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.snailmail.from", new Object[]{new StringTextComponent(stack.func_77978_p().func_74779_i("AddressedFrom")).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY))}).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED).func_240722_b_(Boolean.valueOf(true))));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("delivery_failed", 1) && stack.func_77978_p().func_74767_n("delivery_failed")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.snailmail.delivery_failed").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.RED).func_240713_a_(Boolean.valueOf(true))));
        }
        if (stack.func_77973_b() == ModItems.ENVELOPE_OPEN && (cap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent() && !(stampSlot = ((IItemHandler)cap.orElse(null)).getStackInSlot(27)).func_190926_b() && stampSlot.func_77973_b() == ModItems.STAMP) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.snailmail.stamped").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.GOLD).func_240722_b_(Boolean.valueOf(true))));
        }
    }

    public static boolean isStamped(ItemStack stack) {
        ItemStack stampSlot;
        LazyOptional cap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return cap.isPresent() && !(stampSlot = ((IItemHandler)cap.orElse(null)).getStackInSlot(27)).func_190926_b() && stampSlot.func_77973_b() == ModItems.STAMP;
    }

    public static void setToName(PlayerEntity player, Hand hand, ItemStack stack, String s) {
        EnvelopeItem.putStringChecked(stack, "AddressedTo", s);
        player.func_184611_a(hand, stack);
    }

    public static void setFromName(PlayerEntity player, Hand hand, ItemStack stack, String s) {
        EnvelopeItem.putStringChecked(stack, "AddressedFrom", s);
        player.func_184611_a(hand, stack);
    }

    public static String getString(ItemStack stack, String key) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i(key);
        }
        return "";
    }

    public static void putStringChecked(ItemStack stack, String key, String value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74778_a(key, value);
    }

    protected static void copyTagString(ItemStack original, ItemStack newStack, String key) {
        if (original.func_77942_o() && original.func_77978_p().func_150297_b(key, 8)) {
            EnvelopeItem.putStringChecked(newStack, key, original.func_77978_p().func_74779_i(key));
        }
    }

    public static Optional<ItemStack> convert(ItemStack stack) {
        LazyOptional hOpt;
        boolean fromOpen;
        boolean bl = fromOpen = stack.func_77973_b() == ModItems.ENVELOPE_OPEN;
        if ((fromOpen || stack.func_77973_b() == ModItems.ENVELOPE_CLOSED) && (hOpt = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            IItemHandler newHandler;
            IItemHandler handler = (IItemHandler)hOpt.orElse(null);
            ItemStack newStack = new ItemStack((IItemProvider)(fromOpen ? ModItems.ENVELOPE_CLOSED : ModItems.ENVELOPE_OPEN));
            LazyOptional nHOpt = newStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            if (nHOpt.isPresent() && (newHandler = (IItemHandler)nHOpt.orElse(null)) instanceof ItemStackHandler) {
                ItemStackHandler newH = (ItemStackHandler)newHandler;
                for (int i = 0; i < Math.min(newH.getSlots(), handler.getSlots()); ++i) {
                    newH.setStackInSlot(i, handler.getStackInSlot(i));
                }
                EnvelopeItem.copyTagString(stack, newStack, "AddressedTo");
                EnvelopeItem.copyTagString(stack, newStack, "AddressedFrom");
                return Optional.of(newStack);
            }
        }
        return Optional.empty();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!stack.func_190926_b() && stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) != null && playerIn instanceof ServerPlayerEntity) {
            Optional<ItemStack> open;
            if (stack.func_77973_b() == ModItems.ENVELOPE_OPEN) {
                EnvelopeItem.openGUI((ServerPlayerEntity)playerIn, stack);
                return ActionResult.func_226248_a_((Object)stack);
            }
            if (stack.func_77973_b() == ModItems.ENVELOPE_CLOSED && (open = EnvelopeItem.convert(stack)).isPresent()) {
                return ActionResult.func_226248_a_((Object)open.get());
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public static EnvelopeContainer getClientContainer(int id, PlayerInventory playerInventory, PacketBuffer extra) {
        if (extra.readableBytes() > 0) {
            try {
                String toName = extra.func_150789_c(35);
                String fromName = "";
                if (extra.readableBytes() > 0) {
                    fromName = extra.func_150789_c(35);
                }
                return new EnvelopeContainer(id, (IInventory)playerInventory, (IItemHandler)new ItemStackHandler(28), toName, fromName);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return new EnvelopeContainer(id, (IInventory)playerInventory, (IItemHandler)new ItemStackHandler(28));
    }

    public static IContainerProvider getServerContainerProvider(ItemStack stack) {
        return (id, playerInventory, serverPlayer) -> new EnvelopeContainer(id, (IInventory)playerInventory, (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null));
    }

    public static void openGUI(ServerPlayerEntity player, ItemStack stack) {
        IContainerProvider provider = EnvelopeItem.getServerContainerProvider(stack);
        SimpleNamedContainerProvider namedProvider = new SimpleNamedContainerProvider(provider, title);
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)namedProvider, buf -> {
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_150297_b("AddressedTo", 8)) {
                    buf.func_211400_a(stack.func_77978_p().func_74779_i("AddressedTo"), 35);
                }
                if (stack.func_77978_p().func_150297_b("AddressedFrom", 8)) {
                    buf.func_211400_a(stack.func_77978_p().func_74779_i("AddressedFrom"), 35);
                }
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new EnvelopeCapabilityProvider(stack, nbt, this.isOpen);
    }

    public static class EnvelopeCapabilityProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private ItemStackHandler handler;
        public final LazyOptional<ItemStackHandler> handlerOptional;
        private ItemStack stack;

        public EnvelopeCapabilityProvider(ItemStack stack, CompoundNBT compound, boolean isOpen) {
            this.handler = new ItemStackHandler(isOpen ? 28 : 27);
            this.handlerOptional = LazyOptional.of(() -> this.handler);
            this.stack = stack;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !this.stack.func_190926_b()) {
                return this.handlerOptional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return this.handler.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt != null) {
                this.handler.deserializeNBT(nbt);
            }
        }
    }

    public static class EnvelopeContainer
    extends Container {
        private final int SLOT_COUNT;
        private final IItemHandler items;
        public final String clientStartToName;
        public final String clientStartFromName;

        public EnvelopeContainer(int id, IInventory playerInventory, IItemHandler items) {
            this(id, playerInventory, items, "", "");
        }

        public EnvelopeContainer(int id, IInventory playerInventory, IItemHandler items, String toName, String fromName) {
            super(ModContainers.ENVELOPE, id);
            this.clientStartToName = toName;
            this.clientStartFromName = fromName;
            this.items = items;
            this.SLOT_COUNT = items.getSlots();
            this.addOwnSlots();
            this.addPlayerSlots(playerInventory);
        }

        private void addPlayerSlots(IInventory playerInventory) {
            int row;
            for (row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    int x = 8 + col * 18;
                    int y = row * 18 + 96;
                    this.func_75146_a(new Slot(playerInventory, col + row * 9 + 9, x, y));
                }
            }
            for (row = 0; row < 9; ++row) {
                int x = 8 + row * 18;
                int y = 154;
                this.func_75146_a(new Slot(playerInventory, row, x, y));
            }
        }

        private void addOwnSlots() {
            for (int i = 0; i < 27; ++i) {
                int yCoord = i / 9 * 18;
                int xCoord = i % 9 * 18;
                this.func_75146_a((Slot)new NoItemCapSlot(this.items, i, 8 + xCoord, 26 + yCoord));
            }
            this.func_75146_a((Slot)new StampSlot(this.items, 27, 152, 6));
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (itemstack1.func_77973_b() == ModItems.STAMP && index >= this.SLOT_COUNT && !this.func_75135_a(itemstack1, 27, 28, false)) {
                    return ItemStack.field_190927_a;
                }
                if (index < this.SLOT_COUNT ? !this.func_75135_a(itemstack1, this.SLOT_COUNT, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.SLOT_COUNT, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            }
            return itemstack;
        }

        public boolean func_75145_c(PlayerEntity player) {
            if (player.func_184614_ca().func_77973_b() == ModItems.ENVELOPE_OPEN || player.func_184592_cb().func_77973_b() == ModItems.ENVELOPE_OPEN) {
                if (player.func_184614_ca().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null) == this.items) {
                    return true;
                }
                return player.func_184592_cb().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null) == this.items;
            }
            return false;
        }
    }
}

