/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import com.mojang.authlib.GameProfile;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.SnailBoxMemberScreen;
import dev.itsmeow.snailmail.util.RandomUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSnailBoxPacket {
    public String name = "";
    public String memberUsername = "";
    public boolean addMember;
    public boolean isPublic;
    public final Type type;

    public UpdateSnailBoxPacket(String name) {
        this.type = Type.NAME;
        this.name = name;
    }

    public UpdateSnailBoxPacket(String memberUsername, boolean add) {
        this.type = Type.MEMBER;
        this.memberUsername = memberUsername;
        this.addMember = add;
    }

    public UpdateSnailBoxPacket(boolean isPublic) {
        this.type = Type.PUBLIC;
        this.isPublic = isPublic;
    }

    public static void encode(UpdateSnailBoxPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.type.ordinal());
        switch (pkt.type) {
            case NAME: {
                buf.func_211400_a(pkt.name, 35);
                break;
            }
            case MEMBER: {
                buf.func_211400_a(pkt.memberUsername, 35);
                buf.writeBoolean(pkt.addMember);
                break;
            }
            case PUBLIC: {
                buf.writeBoolean(pkt.isPublic);
            }
        }
    }

    public static UpdateSnailBoxPacket decode(PacketBuffer buf) {
        Type type = Type.values()[buf.readInt()];
        switch (type) {
            case NAME: {
                return new UpdateSnailBoxPacket(buf.func_150789_c(35));
            }
            case MEMBER: {
                return new UpdateSnailBoxPacket(buf.func_150789_c(35), buf.readBoolean());
            }
            case PUBLIC: {
                return new UpdateSnailBoxPacket(buf.readBoolean());
            }
        }
        return null;
    }

    private static void reply(Supplier<NetworkEvent.Context> ctx, String name, boolean added) {
        SnailMail.HANDLER.sendTo((Object)new UpdateSnailBoxPacket(name, added), ctx.get().getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class Handler {
        public static void handle(UpdateSnailBoxPacket msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                ctx.get().enqueueWork(() -> {
                    SnailBoxBlockEntity te;
                    ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (sender.field_71070_bA instanceof SnailBoxBlockEntity.SnailBoxContainer && (te = ((SnailBoxBlockEntity.SnailBoxContainer)sender.field_71070_bA).getTile((PlayerEntity)sender)) != null && te.getOwner().equals(PlayerEntity.func_146094_a((GameProfile)sender.func_146103_bH()))) {
                        switch (msg.type) {
                            case NAME: {
                                String newName = RandomUtil.filterAllowedCharacters(msg.name, true);
                                if (newName.length() > 35) break;
                                te.setName(newName);
                                break;
                            }
                            case MEMBER: {
                                String username = msg.memberUsername;
                                new Thread(() -> Handler.lambda$null$1(sender, username, (Supplier)ctx, te, msg)).start();
                                break;
                            }
                            case PUBLIC: {
                                te.setPublic(msg.isPublic);
                            }
                        }
                    }
                });
            } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT && msg.type == Type.MEMBER) {
                ctx.get().enqueueWork(() -> {
                    if (Minecraft.func_71410_x().field_71462_r instanceof SnailBoxMemberScreen) {
                        SnailBoxMemberScreen screen = (SnailBoxMemberScreen)Minecraft.func_71410_x().field_71462_r;
                        String name = msg.memberUsername;
                        if (!name.equals("FAILED_ID_VERIFY")) {
                            if (msg.addMember) {
                                ((SnailBoxBlockEntity.SnailBoxContainer)screen.parent.func_212873_a_()).memberUsers.add(name);
                            } else {
                                ((SnailBoxBlockEntity.SnailBoxContainer)screen.parent.func_212873_a_()).memberUsers.remove(name);
                            }
                            screen.refreshList();
                        } else {
                            screen.failedAdd();
                        }
                    }
                });
            }
            ctx.get().setPacketHandled(true);
        }

        private static /* synthetic */ void lambda$null$1(ServerPlayerEntity sender, String username, Supplier ctx, SnailBoxBlockEntity te, UpdateSnailBoxPacket msg) {
            GameProfile profile = sender.func_184102_h().func_152358_ax().func_152655_a(username);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> Handler.lambda$null$0(profile, username, te, msg, (Supplier)ctx));
        }

        private static /* synthetic */ void lambda$null$0(GameProfile profile, String username, SnailBoxBlockEntity te, UpdateSnailBoxPacket msg, Supplier ctx) {
            UUID uuid = null;
            if ((profile == null || profile.getId() == null) && UUID.fromString(username) != null) {
                uuid = UUID.fromString(username);
                if (!uuid.equals(te.getOwner())) {
                    if (msg.addMember) {
                        te.addMember(uuid);
                    } else {
                        te.removeMember(uuid);
                    }
                }
            } else if (profile != null && profile.getId() != null) {
                uuid = profile.getId();
                if (!uuid.equals(te.getOwner())) {
                    if (msg.addMember) {
                        te.addMember(profile.getId());
                    } else {
                        te.removeMember(profile.getId());
                    }
                }
            } else if (msg.addMember) {
                UpdateSnailBoxPacket.reply(ctx, "FAILED_ID_VERIFY", false);
            }
            if (!(uuid == null || uuid.equals(te.getOwner()) && msg.addMember)) {
                UpdateSnailBoxPacket.reply(ctx, username, msg.addMember);
            }
        }
    }

    public static enum Type {
        NAME,
        MEMBER,
        PUBLIC;

    }
}

