/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.util;

import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Location {
    public static final Location ZERO = new Location((RegistryKey<World>)World.field_234918_g_, 0, 0, 0);
    private final RegistryKey<World> dimension;
    private final int x;
    private final int y;
    private final int z;

    public Location(World world, BlockPos pos) {
        this((RegistryKey<World>)world.func_234923_W_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(World world, int x, int y, int z) {
        this((RegistryKey<World>)world.func_234923_W_(), x, y, z);
    }

    public Location(RegistryKey<World> dimension, BlockPos pos) {
        this(dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(RegistryKey<World> dimension, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos toBP() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void write(PacketBuffer buf) {
        buf.func_211400_a(this.dimension.func_240901_a_().toString(), 60);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static Location read(PacketBuffer buf) {
        return new Location((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(60))), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        return tag;
    }

    public static Location read(CompoundNBT tag) {
        return new Location((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("dim"))), tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public ServerWorld getWorld(MinecraftServer server) {
        return server.func_71218_a(this.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.dimension.func_240901_a_().toString(), this.x, this.y, this.z);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location otherL = (Location)other;
        if (this.getX() != otherL.getX()) {
            return false;
        }
        if (this.getY() != otherL.getY()) {
            return false;
        }
        if (this.getZ() != otherL.getZ()) {
            return false;
        }
        return this.getDimension() == otherL.getDimension();
    }

    public Vector3d asVec() {
        return new Vector3d((double)this.x + 0.5, (double)this.y, (double)this.z + 0.5);
    }
}

