/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;
import snownee.snow.MainModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.IWaterLoggableSnowVariant;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.block.SnowTextureTile;
import snownee.snow.block.state.SnowFenceBlockState;

public class SnowFenceBlock
extends FenceBlock
implements IWaterLoggableSnowVariant {
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final Material NO_MATCH = new Material.Builder(MaterialColor.field_151663_o).func_200506_i();
    protected final StateContainer<Block, BlockState> ourStateContainer;

    public SnowFenceBlock(Block.Properties properties) {
        super(properties);
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.ourStateContainer = builder.func_206893_a(SnowFenceBlockState::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.ourStateContainer.func_177621_b()).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_204514_u, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public StateContainer<Block, BlockState> func_176194_O() {
        return this.ourStateContainer;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SnowTextureTile();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ModBlock.pickBlock((BlockState)state, (RayTraceResult)target, (IBlockReader)world, (BlockPos)pos, (PlayerEntity)player);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public Material func_149688_o(BlockState state) {
        return NO_MATCH;
    }

    public Material getMaterial(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getRaw(state, world, pos).func_185904_a();
    }

    public boolean canConnect(BlockState otherState, boolean isSolid, Direction dirToCheck, Material ourMaterial) {
        Block block = otherState.func_177230_c();
        boolean isMatchingFence = block.func_203417_a(BlockTags.field_219748_G) && otherState.func_185904_a() == ourMaterial;
        boolean isFenceGate = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)otherState, (Direction)dirToCheck);
        return !SnowFenceBlock.func_220073_a((Block)block) && isSolid || isMatchingFence || isFenceGate;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Item item;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState stateIn = world.func_180495_p(blockpos);
        Material mat = NO_MATCH;
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_204514_u, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(MainModule.BLOCK.func_196260_a(stateIn, (IWorldReader)world, blockpos)));
        ItemStack stack = context.func_195996_i();
        NBTHelper data = NBTHelper.of((ItemStack)stack);
        ResourceLocation rl = Util.RL((String)data.getString("BlockEntityTag.Items.0", ""));
        if (rl != null && (item = (Item)ForgeRegistries.ITEMS.getValue(rl)) instanceof BlockItem) {
            mat = ((BlockItem)item).func_179223_d().func_176223_P().func_185904_a();
        }
        BlockPos north = blockpos.func_177978_c();
        BlockPos east = blockpos.func_177974_f();
        BlockPos south = blockpos.func_177968_d();
        BlockPos west = blockpos.func_177976_e();
        BlockState northState = world.func_180495_p(north);
        BlockState eastState = world.func_180495_p(east);
        BlockState southState = world.func_180495_p(south);
        BlockState westState = world.func_180495_p(west);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(this.canConnect(northState, northState.func_224755_d((IBlockReader)world, north, Direction.SOUTH), Direction.SOUTH, mat)))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(this.canConnect(eastState, eastState.func_224755_d((IBlockReader)world, east, Direction.WEST), Direction.WEST, mat)))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(this.canConnect(southState, southState.func_224755_d((IBlockReader)world, south, Direction.NORTH), Direction.NORTH, mat)))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(this.canConnect(westState, westState.func_224755_d((IBlockReader)world, west, Direction.EAST), Direction.EAST, mat)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL) {
            boolean connected = this.canConnect(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d()), facing.func_176734_d(), SnowFenceBlockState.getMaterial(stateIn, (IBlockReader)worldIn, currentPos));
            return (BlockState)stateIn.func_206870_a((IProperty)field_196415_z.get(facing), (Comparable)Boolean.valueOf(connected));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(MainModule.BLOCK.isValidPosition(stateIn, (IWorldReader)worldIn, currentPos, true)));
        }
        return stateIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196409_a, field_196411_b, field_196414_y, field_196413_c, DOWN, field_204514_u});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String key = Util.getTextureItem((ItemStack)stack, (String)"0");
        if (!key.isEmpty()) {
            tooltip.add(new TranslationTextComponent(key, new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        MainModule.fillTextureItems((Tag<Item>)ItemTags.field_219772_G, (Block)this, items);
    }

    public void func_196265_a(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!SnowCommonConfig.snowNeverMelt && worldIn.func_175642_b(LightType.BLOCK, pos) > 11) {
            worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
        }
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        VoxelShape shape = super.func_196247_c(state, worldIn, pos);
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)ModSnowBlock.SNOW_SHAPES_MAGIC[2], (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }
}

