/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block.state;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.dimension.DimensionType;
import snownee.snow.block.SnowFenceBlock;

public class SnowFenceBlockState
extends BlockState {
    private static Map<PositionKey, Material> cachedMaterials = new HashMap<PositionKey, Material>();

    public SnowFenceBlockState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties) {
        super(block, properties);
    }

    public boolean func_224755_d(IBlockReader world, BlockPos pos, @Nonnull Direction side) {
        BlockPos neighborPos = pos.func_177972_a(side);
        BlockState neighborState = world.func_180495_p(neighborPos);
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock.func_203417_a(BlockTags.field_219748_G)) {
            Material neighborMaterial;
            Material ourMaterial = SnowFenceBlockState.getMaterial(world.func_180495_p(pos), world, pos);
            return ourMaterial == (neighborMaterial = SnowFenceBlockState.getMaterial(neighborState, world, neighborPos));
        }
        return super.func_224755_d(world, pos, side);
    }

    public static Material getMaterial(BlockState blockState, IBlockReader world, BlockPos pos) {
        Material material;
        Block block = blockState.func_177230_c();
        if (block instanceof SnowFenceBlock) {
            PositionKey cacheKey;
            if (world instanceof IWorldReader && cachedMaterials.containsKey(cacheKey = new PositionKey((IWorldReader)world, pos))) {
                return cachedMaterials.get(cacheKey);
            }
            material = ((SnowFenceBlock)block).getMaterial(blockState, world, pos);
        } else {
            material = blockState.func_185904_a();
        }
        return material;
    }

    public static void setCachedMaterial(IWorldReader world, BlockPos pos, Material material) {
        cachedMaterials.put(new PositionKey(world, pos), material);
    }

    public static void clearCachedMaterial(IWorldReader world, BlockPos pos) {
        cachedMaterials.remove(new PositionKey(world, pos));
    }

    private static class PositionKey {
        private final DimensionType dim;
        private final boolean remote;
        private final BlockPos pos;

        PositionKey(IWorldReader world, BlockPos pos) {
            this.dim = world.func_201675_m().func_186058_p();
            this.pos = pos.func_185334_h();
            this.remote = world.func_201670_d();
        }

        public int hashCode() {
            int code = this.remote ? 1 : 31;
            code = 31 * code + this.dim.hashCode();
            code = 31 * code + this.pos.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PositionKey) {
                PositionKey other = (PositionKey)obj;
                return this.remote == other.remote && this.dim.equals(other.dim) && this.pos.equals((Object)other.pos);
            }
            return false;
        }
    }
}

