/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.util.Util;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class SnowCommonConfig {
    public static boolean placeSnowInBlock = true;
    public static boolean snowGravity = true;
    public static boolean snowAlwaysReplaceable = true;
    public static boolean snowAccumulationDuringSnowstorm = true;
    public static boolean snowAccumulationDuringSnowfall = false;
    public static boolean snowAccumulationOnSpecialBlocks = true;
    public static boolean thinnerBoundingBox = true;
    public static boolean snowMakingIce = true;
    public static boolean snowOnIce = false;
    public static boolean snowNeverMelt = false;
    public static boolean replaceWorldFeature = true;
    public static boolean sustainGrassIfLayerMoreThanOne = true;
    public static final Set<Block> invalidSupportingBlocks = Sets.newHashSet();
    private static ForgeConfigSpec.BooleanValue placeSnowInBlockCfg;
    private static ForgeConfigSpec.BooleanValue snowGravityCfg;
    private static ForgeConfigSpec.BooleanValue snowAlwaysReplaceableCfg;
    private static ForgeConfigSpec.BooleanValue snowAccumulationDuringSnowstormCfg;
    private static ForgeConfigSpec.BooleanValue snowAccumulationDuringSnowfallCfg;
    private static ForgeConfigSpec.BooleanValue snowAccumulationOnSpecialBlocksCfg;
    private static ForgeConfigSpec.BooleanValue thinnerBoundingBoxCfg;
    private static ForgeConfigSpec.BooleanValue snowMakingIceCfg;
    private static ForgeConfigSpec.BooleanValue snowOnIceCfg;
    private static ForgeConfigSpec.BooleanValue snowNeverMeltCfg;
    private static ForgeConfigSpec.BooleanValue replaceWorldFeatureCfg;
    private static ForgeConfigSpec.BooleanValue sustainGrassIfLayerMoreThanOneCfg;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> invalidSupportingBlocksCfg;
    static final ForgeConfigSpec spec;

    private SnowCommonConfig(ForgeConfigSpec.Builder builder) {
        placeSnowInBlockCfg = builder.define("placeSnowInBlock", placeSnowInBlock);
        snowGravityCfg = builder.define("snowGravity", snowGravity);
        snowAlwaysReplaceableCfg = builder.define("snowAlwaysReplaceable", snowAlwaysReplaceable);
        snowAccumulationDuringSnowstormCfg = builder.define("snowAccumulationDuringSnowstorm", snowAccumulationDuringSnowstorm);
        snowAccumulationDuringSnowfallCfg = builder.define("snowAccumulationDuringSnowfall", snowAccumulationDuringSnowfall);
        snowAccumulationOnSpecialBlocksCfg = builder.define("snowAccumulationOnSpecialBlocks", snowAccumulationOnSpecialBlocks);
        thinnerBoundingBoxCfg = builder.define("thinnerBoundingBox", thinnerBoundingBox);
        snowMakingIceCfg = builder.define("snowMakingIce", snowMakingIce);
        snowOnIceCfg = builder.define("snowOnIce", snowOnIce);
        snowNeverMeltCfg = builder.define("snowNeverMelt", snowNeverMelt);
        replaceWorldFeatureCfg = builder.define("replaceWorldFeature", replaceWorldFeature);
        sustainGrassIfLayerMoreThanOneCfg = builder.comment("Requires Mixin").define("sustainGrassIfLayerMoreThanOne", sustainGrassIfLayerMoreThanOne);
        invalidSupportingBlocksCfg = builder.defineList("invalidSupportingBlocks", () -> Arrays.asList("ice", "packed_ice", "barrier"), (Predicate)Predicates.alwaysTrue());
    }

    public static void refresh() {
        placeSnowInBlock = (Boolean)placeSnowInBlockCfg.get();
        snowGravity = (Boolean)snowGravityCfg.get();
        snowAlwaysReplaceable = (Boolean)snowAlwaysReplaceableCfg.get();
        snowAccumulationDuringSnowstorm = (Boolean)snowAccumulationDuringSnowstormCfg.get();
        snowAccumulationDuringSnowfall = (Boolean)snowAccumulationDuringSnowfallCfg.get();
        snowAccumulationOnSpecialBlocks = (Boolean)snowAccumulationOnSpecialBlocksCfg.get();
        thinnerBoundingBox = (Boolean)thinnerBoundingBoxCfg.get();
        snowMakingIce = (Boolean)snowMakingIceCfg.get();
        snowOnIce = (Boolean)snowOnIceCfg.get();
        snowNeverMelt = (Boolean)snowNeverMeltCfg.get();
        replaceWorldFeature = (Boolean)replaceWorldFeatureCfg.get();
        sustainGrassIfLayerMoreThanOne = (Boolean)sustainGrassIfLayerMoreThanOneCfg.get();
        invalidSupportingBlocks.clear();
        ((List)invalidSupportingBlocksCfg.get()).forEach(id -> {
            ResourceLocation rl = Util.RL((String)id);
            if (rl != null && ForgeRegistries.BLOCKS.containsKey(rl)) {
                invalidSupportingBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(rl));
            }
        });
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        SnowCommonConfig.refresh();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(SnowCommonConfig::new);
        spec = (ForgeConfigSpec)specPair.getRight();
    }
}

