/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.device;

import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public final class MultiDrawBatch {
    private final long pPointer;
    private final long pCount;
    private final long pBaseVertex;
    private final int capacity;
    private int maxVertexCount;
    private int count;

    public MultiDrawBatch(int capacity) {
        this.pPointer = MemoryUtil.memAddress((CustomBuffer)MemoryUtil.memAllocPointer((int)capacity));
        this.pCount = MemoryUtil.memAddress((IntBuffer)MemoryUtil.memAllocInt((int)capacity));
        this.pBaseVertex = MemoryUtil.memAddress((IntBuffer)MemoryUtil.memAllocInt((int)capacity));
        this.capacity = capacity;
    }

    long getPointerBuffer() {
        return this.pPointer;
    }

    long getCountBuffer() {
        return this.pCount;
    }

    long getBaseVertexBuffer() {
        return this.pBaseVertex;
    }

    public int getMaxVertexCount() {
        return this.maxVertexCount;
    }

    int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.maxVertexCount = 0;
    }

    public void add(long pointer, int count, int baseVertex) {
        if (this.count >= this.capacity) {
            throw new BufferUnderflowException();
        }
        MemoryUtil.memPutAddress((long)(this.pPointer + (long)(this.count * Pointer.POINTER_SIZE)), (long)pointer);
        MemoryUtil.memPutInt((long)(this.pCount + (long)(this.count * 4)), (int)count);
        MemoryUtil.memPutInt((long)(this.pBaseVertex + (long)(this.count * 4)), (int)baseVertex);
        ++this.count;
        this.maxVertexCount = Math.max(this.maxVertexCount, count);
    }

    public void delete() {
        MemoryUtil.nmemFree((long)this.pPointer);
        MemoryUtil.nmemFree((long)this.pCount);
        MemoryUtil.nmemFree((long)this.pBaseVertex);
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }
}

