/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphInfo;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4076;
import net.minecraft.class_854;

public class RenderSection {
    private final SodiumWorldRenderer worldRenderer;
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final ChunkGraphInfo graphInfo;
    private final int chunkId;
    private final long regionId;
    private final RenderSection[] adjacent = new RenderSection[DirectionUtil.ALL_DIRECTIONS.length];
    private ChunkRenderData data = ChunkRenderData.ABSENT;
    private CompletableFuture<?> rebuildTask = null;
    private ChunkUpdateType pendingUpdate;
    private boolean tickable;
    private boolean disposed;
    private int lastAcceptedBuildTime = -1;
    private int flags;

    public RenderSection(SodiumWorldRenderer worldRenderer, int chunkX, int chunkY, int chunkZ) {
        this.worldRenderer = worldRenderer;
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.graphInfo = new ChunkGraphInfo(this);
        int rX = this.getChunkX() & 7;
        int rY = this.getChunkY() & 3;
        int rZ = this.getChunkZ() & 7;
        this.chunkId = RenderRegion.getChunkIndex(rX, rY, rZ);
        this.regionId = RenderRegion.getRegionKeyForChunk(this.chunkX, this.chunkY, this.chunkZ);
    }

    public RenderSection getAdjacent(class_2350 dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setAdjacentNode(class_2350 dir, RenderSection node) {
        this.adjacent[dir.ordinal()] = node;
    }

    public void cancelRebuildTask() {
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
    }

    public ChunkRenderData getData() {
        return this.data;
    }

    public void delete() {
        this.cancelRebuildTask();
        this.setData(ChunkRenderData.ABSENT);
        this.disposed = true;
    }

    public void setData(ChunkRenderData info) {
        if (info == null) {
            throw new NullPointerException("Mesh information must not be null");
        }
        this.worldRenderer.onChunkRenderUpdated(this.chunkX, this.chunkY, this.chunkZ, this.data, info);
        this.data = info;
        this.tickable = !info.getAnimatedSprites().isEmpty();
        this.flags = info.getFlags();
    }

    public int getFlags() {
        return this.flags;
    }

    public class_4076 getChunkPos() {
        return class_4076.method_18676((int)this.chunkX, (int)this.chunkY, (int)this.chunkZ);
    }

    public void tick() {
        for (class_1058 sprite : this.data.getAnimatedSprites()) {
            SpriteUtil.markSpriteActive(sprite);
        }
    }

    public int getOriginX() {
        return this.chunkX << 4;
    }

    public int getOriginY() {
        return this.chunkY << 4;
    }

    public int getOriginZ() {
        return this.chunkZ << 4;
    }

    public double getSquaredDistance(class_2338 pos) {
        return this.getSquaredDistance((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public double getSquaredDistance(double x, double y, double z) {
        double xDist = x - this.getCenterX();
        double yDist = y - this.getCenterY();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    private double getCenterX() {
        return (double)this.getOriginX() + 8.0;
    }

    private double getCenterY() {
        return (double)this.getOriginY() + 8.0;
    }

    private double getCenterZ() {
        return (double)this.getOriginZ() + 8.0;
    }

    public double getSquaredDistanceXZ(double x, double z) {
        double xDist = x - this.getCenterX();
        double zDist = z - this.getCenterZ();
        return xDist * xDist + zDist * zDist;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public ChunkRenderBounds getBounds() {
        return this.data.getBounds();
    }

    public boolean isTickable() {
        return this.tickable;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public String toString() {
        return String.format("RenderChunk{chunkX=%d, chunkY=%d, chunkZ=%d}", this.chunkX, this.chunkY, this.chunkZ);
    }

    public ChunkGraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public void setOcclusionData(class_854 occlusionData) {
        this.graphInfo.setOcclusionData(occlusionData);
    }

    public ChunkUpdateType getPendingUpdate() {
        return this.pendingUpdate;
    }

    public void markForUpdate(ChunkUpdateType type) {
        if (this.pendingUpdate == null || type.ordinal() > this.pendingUpdate.ordinal()) {
            this.pendingUpdate = type;
        }
    }

    public void onBuildSubmitted(CompletableFuture<?> task) {
        if (this.rebuildTask != null) {
            this.rebuildTask.cancel(false);
            this.rebuildTask = null;
        }
        this.rebuildTask = task;
        this.pendingUpdate = null;
    }

    public boolean isBuilt() {
        return this.data != ChunkRenderData.ABSENT;
    }

    public boolean canAcceptBuildResults(ChunkBuildResult result) {
        return !this.isDisposed() && result.buildTime > this.lastAcceptedBuildTime;
    }

    public void onBuildFinished(ChunkBuildResult result) {
        this.setData(result.data);
        this.lastAcceptedBuildTime = result.buildTime;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public long getRegionId() {
        return this.regionId;
    }
}

