/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import java.util.List;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;

public class BlockRenderer {
    private final class_5819 random = new class_6575(42L);
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;

    public BlockRenderer(class_310 client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.method_1505();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_310.method_1588();
    }

    public void renderModel(BlockRenderContext ctx, ChunkBuildBuffers buffers, ChunkRenderBounds.Builder bounds) {
        Material material = DefaultMaterials.forBlockState(ctx.state());
        ChunkModelBuilder meshBuilder = buffers.get(material);
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(ctx.state(), ctx.model()));
        class_243 renderOffset = ctx.state().method_26226((class_1922)ctx.world(), ctx.pos());
        for (class_2350 face : DirectionUtil.ALL_DIRECTIONS) {
            List<class_777> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.renderQuadList(ctx, material, lighter, renderOffset, meshBuilder, quads, face, bounds);
        }
        List<class_777> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, material, lighter, renderOffset, meshBuilder, all, null, bounds);
        }
    }

    private List<class_777> getGeometry(BlockRenderContext ctx, class_2350 face) {
        class_5819 random = this.random;
        random.method_43052(ctx.seed());
        return ctx.model().method_4707(ctx.state(), face, random);
    }

    private boolean isFaceVisible(BlockRenderContext ctx, class_2350 face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (class_1922)ctx.world(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, class_243 offset, ChunkModelBuilder builder, List<class_777> quads, class_2350 cullFace, ChunkRenderBounds.Builder bounds) {
        ColorSampler<class_2680> colorizer = null;
        QuadLightData lightData = this.cachedQuadLightData;
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            lighter.calculate(quad, ctx.pos(), lightData, cullFace, quad.getLightFace(), quad.hasShade());
            int[] colors = null;
            if (quad.hasColor()) {
                if (colorizer == null) {
                    colorizer = this.blockColors.getColorProvider(ctx.state());
                }
                colors = this.biomeColorBlender.getColors(ctx.world(), ctx.pos(), quad, colorizer, ctx.state());
            }
            this.writeGeometry(ctx, builder, offset, material, quad, colors, lightData.br, lightData.lm, bounds);
            class_1058 sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, class_243 offset, Material material, BakedQuadView quad, int[] colors, float[] brightness, int[] lightmap, ChunkRenderBounds.Builder bounds) {
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(brightness);
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.method_10216();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.method_10214();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.method_10215();
            out.color = ColorABGR.withAlpha(colors != null ? colors[srcIndex] : -1, brightness[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = lightmap[srcIndex];
            bounds.add(out.x, out.y, out.z, normalFace);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(class_2680 state, class_1087 model) {
        if (this.useAmbientOcclusion && model.method_4708() && state.method_26213() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

